/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.LiteralBase;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL)
final class RawLiteral
implements Expression {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("((\\\\?\\$(\\w+))(?:\\s*|$))");
    private static final String EXPRESSION_PLACEHOLDER = "$E";
    private final List<Expression> content;

    static RawLiteral create(String format, Object ... mixedArgs) {
        Matcher m;
        Assertions.hasText(format, "Cannot create a raw literal without a format.");
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        ArrayList<Object> all = new ArrayList<Object>();
        for (Object mixedArg : mixedArgs) {
            Parameter parameter;
            if (mixedArg instanceof Parameter && !(parameter = (Parameter)mixedArg).isAnon()) {
                parameters.put(parameter.getName(), parameter);
            }
            all.add(mixedArg);
        }
        if (!parameters.isEmpty()) {
            m = EXPRESSION_PATTERN.matcher(format);
            while (m.find()) {
                if (!parameters.containsKey(m.group(3))) continue;
                all.remove(parameters.get(m.group(3)));
            }
        }
        ArrayList<Expression> content = new ArrayList<Expression>();
        m = EXPRESSION_PATTERN.matcher(format);
        int i = 0;
        int cnt = 0;
        while (m.find()) {
            if (EXPRESSION_PLACEHOLDER.equals(m.group(2))) {
                content.add(new RawElement(format.substring(i, m.start(2))));
                if (cnt >= all.size()) {
                    throw new IllegalArgumentException("Too few arguments for the raw literal format `" + format + "`.");
                }
                content.add(RawLiteral.getMixedArg(all.get(cnt++)));
                i = m.end(2);
                continue;
            }
            if (parameters.containsKey(m.group(3))) {
                Parameter e = (Parameter)parameters.get(m.group(3));
                content.add(new RawElement(format.substring(i, m.start(2))));
                content.add(e);
                i = m.end(2);
                all.remove(e);
                continue;
            }
            content.add(new RawElement(format.substring(i, m.end())));
            i = m.end();
        }
        if (cnt < all.size()) {
            throw new IllegalArgumentException("Too many arguments for the raw literal format `" + format + "`.");
        }
        content.add(new RawElement(format.substring(i)));
        return new RawLiteral(Collections.unmodifiableList(content));
    }

    RawLiteral(List<Expression> content) {
        this.content = content;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.content.forEach(expression -> expression.accept(visitor));
        visitor.leave(this);
    }

    private static Expression getMixedArg(Object argument) {
        if (argument instanceof Expression) {
            Expression expression = (Expression)argument;
            return expression;
        }
        return Cypher.literalOf(argument);
    }

    static class RawElement
    extends LiteralBase<String> {
        RawElement(String content) {
            super(RawElement.unescapeEscapedPlaceholders(content));
        }

        @Override
        @NotNull
        public String asString() {
            return (String)this.content;
        }

        private static String unescapeEscapedPlaceholders(String content) {
            return content.replace("\\$E", RawLiteral.EXPRESSION_PLACEHOLDER);
        }
    }
}

