/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ValueRepresentation {
    UNKNOWN(ValueGroup.UNKNOWN, false){

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return UNKNOWN;
        }
    }
    ,
    ANYTHING(ValueGroup.ANYTHING, false){

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return other;
        }
    }
    ,
    GEOMETRY_ARRAY(ValueGroup.GEOMETRY_ARRAY, false),
    ZONED_DATE_TIME_ARRAY(ValueGroup.ZONED_DATE_TIME_ARRAY, false),
    LOCAL_DATE_TIME_ARRAY(ValueGroup.LOCAL_DATE_TIME_ARRAY, false),
    DATE_ARRAY(ValueGroup.DATE_ARRAY, false),
    ZONED_TIME_ARRAY(ValueGroup.ZONED_TIME_ARRAY, false),
    LOCAL_TIME_ARRAY(ValueGroup.LOCAL_TIME_ARRAY, false),
    DURATION_ARRAY(ValueGroup.DURATION_ARRAY, false),
    TEXT_ARRAY(ValueGroup.TEXT_ARRAY, false),
    BOOLEAN_ARRAY(ValueGroup.BOOLEAN_ARRAY, false),
    INT64_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    INT32_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    INT16_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    INT8_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    FLOAT64_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    FLOAT32_ARRAY(ValueGroup.NUMBER_ARRAY, false),
    GEOMETRY(ValueGroup.GEOMETRY, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            PointValue[] points = new PointValue[values.intSize()];
            int i = 0;
            PointValue first = null;
            for (AnyValue value : values) {
                PointValue current = ValueRepresentation.getOrFail(value, PointValue.class);
                if (first == null) {
                    first = current;
                } else {
                    if (!first.getCoordinateReferenceSystem().equals((Object)current.getCoordinateReferenceSystem())) {
                        throw new CypherTypeException("Collections containing point values with different CRS can not be stored in properties.");
                    }
                    if (first.coordinate().length != current.coordinate().length) {
                        throw new CypherTypeException("Collections containing point values with different dimensions can not be stored in properties.");
                    }
                }
                points[i++] = current;
            }
            return Values.pointArray(points);
        }
    }
    ,
    ZONED_DATE_TIME(ValueGroup.ZONED_DATE_TIME, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            ZonedDateTime[] temporals = new ZonedDateTime[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ValueRepresentation.getOrFail(value, DateTimeValue.class).temporal();
            }
            return Values.dateTimeArray(temporals);
        }
    }
    ,
    LOCAL_DATE_TIME(ValueGroup.LOCAL_DATE_TIME, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            LocalDateTime[] temporals = new LocalDateTime[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ValueRepresentation.getOrFail(value, LocalDateTimeValue.class).temporal();
            }
            return Values.localDateTimeArray(temporals);
        }
    }
    ,
    DATE(ValueGroup.DATE, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            LocalDate[] temporals = new LocalDate[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ValueRepresentation.getOrFail(value, DateValue.class).temporal();
            }
            return Values.dateArray(temporals);
        }
    }
    ,
    ZONED_TIME(ValueGroup.ZONED_TIME, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            OffsetTime[] temporals = new OffsetTime[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ((TimeValue)value).temporal();
            }
            return Values.timeArray(temporals);
        }
    }
    ,
    LOCAL_TIME(ValueGroup.LOCAL_TIME, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            LocalTime[] temporals = new LocalTime[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = ((LocalTimeValue)value).temporal();
            }
            return Values.localTimeArray(temporals);
        }
    }
    ,
    DURATION(ValueGroup.DURATION, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            DurationValue[] temporals = new DurationValue[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                temporals[i++] = (DurationValue)value;
            }
            return Values.durationArray(temporals);
        }
    }
    ,
    UTF16_TEXT(ValueGroup.TEXT, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            String[] strings = new String[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                strings[i++] = ((TextValue)value).stringValue();
            }
            return Values.stringArray(strings);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return switch (other) {
                case UTF8_TEXT, UTF16_TEXT, ANYTHING -> UTF16_TEXT;
                default -> UNKNOWN;
            };
        }
    }
    ,
    UTF8_TEXT(ValueGroup.TEXT, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            String[] strings = new String[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                strings[i++] = ((TextValue)value).stringValue();
            }
            return Values.stringArray(strings);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return switch (other) {
                case UTF8_TEXT, ANYTHING -> UTF8_TEXT;
                case UTF16_TEXT -> UTF16_TEXT;
                default -> UNKNOWN;
            };
        }
    }
    ,
    BOOLEAN(ValueGroup.BOOLEAN, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            boolean[] bools = new boolean[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                bools[i++] = ((BooleanValue)value).booleanValue();
            }
            return Values.booleanArray(bools);
        }
    }
    ,
    INT64(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            long[] longs = new long[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                longs[i++] = ValueRepresentation.getOrFail(value, NumberValue.class).longValue();
            }
            return Values.longArray(longs);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return switch (other) {
                case ANYTHING, INT8, INT16, INT32, INT64 -> this;
                case FLOAT32, FLOAT64 -> FLOAT64;
                default -> UNKNOWN;
            };
        }
    }
    ,
    INT32(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            int[] ints = new int[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                ints[i++] = ValueRepresentation.getOrFail(value, IntegralValue.class).intValue();
            }
            return Values.intArray(ints);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return switch (other) {
                case ANYTHING, INT8, INT16, INT32 -> this;
                case INT64 -> INT64;
                case FLOAT32, FLOAT64 -> FLOAT64;
                default -> UNKNOWN;
            };
        }
    }
    ,
    INT16(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            short[] shorts = new short[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                shorts[i++] = ValueRepresentation.getOrFail(value, IntegralValue.class).shortValue();
            }
            return Values.shortArray(shorts);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return switch (other) {
                case ANYTHING, INT8, INT16 -> this;
                case INT32 -> INT32;
                case INT64 -> INT64;
                case FLOAT32 -> FLOAT32;
                case FLOAT64 -> FLOAT64;
                default -> UNKNOWN;
            };
        }
    }
    ,
    INT8(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            byte[] bytes = new byte[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                bytes[i++] = ValueRepresentation.getOrFail(value, ByteValue.class).value();
            }
            return Values.byteArray(bytes);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return switch (other) {
                case ANYTHING, INT8 -> this;
                case INT16 -> INT16;
                case INT32 -> INT32;
                case INT64 -> INT64;
                case FLOAT32 -> FLOAT32;
                case FLOAT64 -> FLOAT64;
                default -> UNKNOWN;
            };
        }
    }
    ,
    FLOAT64(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            double[] doubles = new double[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                doubles[i++] = ((NumberValue)value).doubleValue();
            }
            return Values.doubleArray(doubles);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return switch (other) {
                case ANYTHING, INT8, INT16, INT32, INT64, FLOAT32, FLOAT64 -> this;
                default -> UNKNOWN;
            };
        }
    }
    ,
    FLOAT32(ValueGroup.NUMBER, true){

        @Override
        public ArrayValue arrayOf(SequenceValue values) {
            float[] floats = new float[values.intSize()];
            int i = 0;
            for (AnyValue value : values) {
                NumberValue asNumberValue = ValueRepresentation.getOrFail(value, NumberValue.class);
                floats[i] = asNumberValue instanceof FloatValue ? ((FloatValue)asNumberValue).value() : (float)asNumberValue.longValue();
                ++i;
            }
            return Values.floatArray(floats);
        }

        @Override
        public ValueRepresentation coerce(ValueRepresentation other) {
            return switch (other) {
                case ANYTHING, INT8, INT16, FLOAT32 -> this;
                case INT32, INT64, FLOAT64 -> FLOAT64;
                default -> UNKNOWN;
            };
        }
    }
    ,
    NO_VALUE(ValueGroup.NO_VALUE, false);

    private final ValueGroup group;
    private final boolean canCreateArrayOf;

    private ValueRepresentation(ValueGroup group, boolean canCreateArrayOf) {
        this.group = group;
        this.canCreateArrayOf = canCreateArrayOf;
    }

    public boolean canCreateArrayOfValueGroup() {
        return this.canCreateArrayOf;
    }

    public ValueGroup valueGroup() {
        return this.group;
    }

    public ArrayValue arrayOf(SequenceValue values) {
        AnyValue prev = null;
        for (AnyValue value : values) {
            if (value == Values.NO_VALUE) {
                throw new CypherTypeException("Collections containing null values can not be stored in properties.");
            }
            if (value instanceof SequenceValue) {
                throw new CypherTypeException("Collections containing collections can not be stored in properties.");
            }
            if (prev != null && prev.valueRepresentation().valueGroup() != value.valueRepresentation().valueGroup()) {
                throw new CypherTypeException("Neo4j only supports a subset of Cypher types for storage as singleton or array properties. Please refer to section cypher/syntax/values of the manual for more details.");
            }
            if (!value.valueRepresentation().canCreateArrayOfValueGroup()) {
                if (value instanceof Value) {
                    Value v = (Value)value;
                    throw CypherTypeException.expectedPrimitivePropertyValue((String)String.valueOf(v), (String)v.prettyPrint(), (String)v.getTypeName().toUpperCase(), (Boolean)true);
                }
                throw CypherTypeException.expectedPrimitivePropertyValue((String)String.valueOf(value), (String)String.valueOf(value), (String)value.getTypeName().toUpperCase(), (Boolean)true);
            }
            prev = value;
        }
        throw ValueRepresentation.failureOld();
    }

    public ValueRepresentation coerce(ValueRepresentation other) {
        if (this.valueGroup() == other.valueGroup() || other.valueGroup() == ValueGroup.ANYTHING) {
            return this;
        }
        if (this.valueGroup() == ValueGroup.ANYTHING) {
            return other;
        }
        return UNKNOWN;
    }

    private static <T> T getOrFail(AnyValue value, Class<T> type) {
        if (type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        if (value == Values.NO_VALUE) {
            throw new CypherTypeException("Collections containing null values can not be stored in properties.");
        }
        if (value instanceof SequenceValue) {
            throw new CypherTypeException("Collections containing collections can not be stored in properties.");
        }
        throw ValueRepresentation.failure(value);
    }

    private static CypherTypeException failureOld() {
        throw new CypherTypeException("Property values can only be of primitive types or arrays thereof");
    }

    private static CypherTypeException failure(AnyValue got) {
        if (got instanceof Value) {
            Value v = (Value)got;
            throw CypherTypeException.expectedPrimitivePropertyValue((String)String.valueOf(v), (String)v.prettyPrint(), (String)v.getTypeName().toUpperCase(), (Boolean)false);
        }
        throw CypherTypeException.expectedPrimitivePropertyValue((String)String.valueOf(got), (String)String.valueOf(got), (String)got.getTypeName().toUpperCase(), (Boolean)false);
    }
}

