/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import org.neo4j.memory.HeapEstimatorCache;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;

public class DefaultScopedMemoryTracker
implements ScopedMemoryTracker {
    private final MemoryTracker delegate;
    private long trackedNative;
    private long trackedHeap;
    private boolean isClosed;
    private final HeapEstimatorCache heapEstimatorCache;

    public DefaultScopedMemoryTracker(MemoryTracker delegate) {
        this.delegate = delegate;
        this.heapEstimatorCache = HeapEstimatorCache.NoHeapEstimatorCache.INSTANCE;
    }

    public DefaultScopedMemoryTracker(MemoryTracker delegate, HeapEstimatorCache heapEstimatorCache) {
        this.delegate = delegate;
        this.heapEstimatorCache = heapEstimatorCache;
    }

    @Override
    public long usedNativeMemory() {
        return this.trackedNative;
    }

    @Override
    public long estimatedHeapMemory() {
        return this.trackedHeap;
    }

    @Override
    public void allocateNative(long bytes) {
        this.throwIfClosed();
        this.delegate.allocateNative(bytes);
        this.trackedNative += bytes;
    }

    @Override
    public void releaseNative(long bytes) {
        this.throwIfClosed();
        this.delegate.releaseNative(bytes);
        this.trackedNative -= bytes;
    }

    @Override
    public void allocateHeap(long bytes) {
        this.throwIfClosed();
        this.delegate.allocateHeap(bytes);
        this.trackedHeap += bytes;
    }

    @Override
    public void releaseHeap(long bytes) {
        this.throwIfClosed();
        this.delegate.releaseHeap(bytes);
        this.trackedHeap -= bytes;
    }

    private void throwIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Should not use a closed ScopedMemoryTracker");
        }
    }

    @Override
    public long heapHighWaterMark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.heapEstimatorCache.fullReset();
        this.delegate.releaseNative(this.trackedNative);
        this.delegate.releaseHeap(this.trackedHeap);
        this.trackedNative = 0L;
        this.trackedHeap = 0L;
    }

    @Override
    public void close() {
        this.heapEstimatorCache.fullReset();
        if (!(this.delegate instanceof ScopedMemoryTracker) || !((ScopedMemoryTracker)this.delegate).isClosed()) {
            this.delegate.releaseNative(this.trackedNative);
            this.delegate.releaseHeap(this.trackedHeap);
        }
        this.trackedNative = 0L;
        this.trackedHeap = 0L;
        this.isClosed = true;
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        return new DefaultScopedMemoryTracker(this, this.getHeapEstimatorCache());
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public HeapEstimatorCache getHeapEstimatorCache() {
        return this.heapEstimatorCache;
    }
}

