/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.homedb;

import java.time.Clock;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.driver.internal.homedb.HomeDatabaseCache;
import org.neo4j.driver.internal.homedb.HomeDatabaseCacheKey;

final class HomeDatabaseCacheImpl
implements HomeDatabaseCache {
    private final Map<HomeDatabaseCacheKey, Entry> keyToEntry = new HashMap<HomeDatabaseCacheKey, Entry>();
    private final Set<BoltConnection> ssrEnabledBoltConnections = new HashSet<BoltConnection>();
    private final Set<BoltConnection> ssrDisabledBoltConnections = new HashSet<BoltConnection>();
    private final int sizeLimit;
    private final int pruneSize;
    private final Clock clock;
    private boolean enabled;

    public HomeDatabaseCacheImpl(int sizeLimit, Clock clock) {
        this.sizeLimit = sizeLimit;
        this.pruneSize = Math.max((int)Math.min((double)sizeLimit, 1.0 / Math.log(2.147483647E9) * 0.8 * (double)sizeLimit * Math.log(sizeLimit)), 1);
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public synchronized Optional<String> get(HomeDatabaseCacheKey key) {
        return this.enabled ? Optional.ofNullable(this.keyToEntry.computeIfPresent(key, (ignored, entry) -> new Entry(entry.database(), this.clock.millis()))).map(Entry::database) : Optional.empty();
    }

    @Override
    public synchronized void put(HomeDatabaseCacheKey key, String value) {
        this.prune();
        this.keyToEntry.put(key, new Entry(value, -1L));
    }

    @Override
    public synchronized void onOpen(BoltConnection boltConnection) {
        if (boltConnection.serverSideRoutingEnabled()) {
            this.ssrEnabledBoltConnections.add(boltConnection);
        } else {
            this.ssrDisabledBoltConnections.add(boltConnection);
        }
        this.updateEnabled();
    }

    @Override
    public synchronized void onClose(BoltConnection boltConnection) {
        if (boltConnection.serverSideRoutingEnabled()) {
            this.ssrEnabledBoltConnections.remove(boltConnection);
        } else {
            this.ssrDisabledBoltConnections.remove(boltConnection);
        }
        this.updateEnabled();
    }

    private synchronized void prune() {
        if (this.keyToEntry.size() >= this.sizeLimit) {
            List<Entry> pruningList = this.keyToEntry.values().stream().sorted(Comparator.comparing(Entry::lastUsed)).limit(this.pruneSize).toList();
            this.keyToEntry.values().removeAll(pruningList);
        }
    }

    private synchronized void updateEnabled() {
        this.enabled = !this.ssrEnabledBoltConnections.isEmpty() && this.ssrDisabledBoltConnections.isEmpty();
    }

    synchronized int size() {
        return this.keyToEntry.size();
    }

    private record Entry(String database, long lastUsed) {
    }
}

