/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.routed.impl.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;

public class FutureUtil {
    public static CompletionException asCompletionException(Throwable error) {
        if (error instanceof CompletionException) {
            return (CompletionException)error;
        }
        return new CompletionException(error);
    }

    public static Throwable completionExceptionCause(Throwable error) {
        if (error instanceof CompletionException) {
            return error.getCause();
        }
        return error;
    }

    public static <T> CompletableFuture<T> onErrorContinue(CompletableFuture<T> future, Throwable errorRecorder, Function<Throwable, ? extends CompletionStage<T>> onErrorAction) {
        Objects.requireNonNull(future);
        return ((CompletableFuture)future.handle((value, error) -> {
            if (error != null) {
                FutureUtil.combineErrors(errorRecorder, error);
                return new CompletionResult<Object>(null, (Throwable)error);
            }
            return new CompletionResult<Object>(value, null);
        })).thenCompose(result -> {
            if (result.value != null) {
                return CompletableFuture.completedFuture(result.value);
            }
            return (CompletionStage)onErrorAction.apply(result.error);
        });
    }

    public static CompletionException combineErrors(Throwable error1, Throwable error2) {
        if (error1 != null && error2 != null) {
            Throwable cause1 = FutureUtil.completionExceptionCause(error1);
            Throwable cause2 = FutureUtil.completionExceptionCause(error2);
            FutureUtil.addSuppressed(cause1, cause2);
            return FutureUtil.asCompletionException(cause1);
        }
        if (error1 != null) {
            return FutureUtil.asCompletionException(error1);
        }
        if (error2 != null) {
            return FutureUtil.asCompletionException(error2);
        }
        return null;
    }

    public static void addSuppressed(Throwable mainError, Throwable error) {
        if (mainError != error) {
            mainError.addSuppressed(error);
        }
    }

    public static <T> T joinNowOrElseThrow(CompletableFuture<T> future, Supplier<? extends RuntimeException> exceptionSupplier) {
        if (future.isDone()) {
            return future.join();
        }
        throw exceptionSupplier.get();
    }

    private record CompletionResult<T>(T value, Throwable error) {
    }
}

