/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public final class VarHandleUtils {
    private VarHandleUtils() {
    }

    public static VarHandle getVarHandle(MethodHandles.Lookup lookup, String name) {
        return VarHandleUtils.getVarHandle(lookup, lookup.lookupClass(), name);
    }

    public static VarHandle getVarHandle(MethodHandles.Lookup lookup, Class<?> clazz, String name) {
        try {
            return VarHandleUtils.getVarHandle(lookup, clazz, name, clazz.getDeclaredField(name).getType());
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static VarHandle getVarHandle(MethodHandles.Lookup lookup, Class<?> clazz, String name, Class<?> type) {
        try {
            return lookup.findVarHandle(clazz, name, type).withInvokeExactBehavior();
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static VarHandle arrayElementVarHandle(Class<?> arrayClass) {
        return MethodHandles.arrayElementVarHandle(arrayClass).withInvokeExactBehavior();
    }

    public static void consumeLong(long value) {
    }

    public static void consumeInt(int value) {
    }
}

