/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Arrays;
import java.util.Comparator;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.Comparison;
import org.neo4j.values.TernaryComparator;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualValues;

public abstract class PathValue
extends VirtualPathValue {
    private static final long DIRECT_PATH_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DirectPathValue.class);

    public abstract NodeValue startNode();

    public abstract NodeValue endNode();

    public abstract NodeValue[] nodes();

    public abstract RelationshipValue[] relationships();

    @Override
    public long[] nodeIds() {
        NodeValue[] nodes = this.nodes();
        long[] nodeIds = new long[nodes.length];
        for (int i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = nodes[i].id();
        }
        return nodeIds;
    }

    @Override
    public long[] relationshipIds() {
        RelationshipValue[] relationionships = this.relationships();
        long[] relIds = new long[relationionships.length];
        for (int i = 0; i < relIds.length; ++i) {
            relIds[i] = relationionships[i].id();
        }
        return relIds;
    }

    @Override
    public ListValue relationshipsAsList() {
        return VirtualValues.fromList(Arrays.asList(this.relationships()));
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        if (writer.entityMode() == AnyValueWriter.EntityMode.REFERENCE) {
            writer.writePathReference(this.nodeIds(), this.relationshipIds());
        } else {
            writer.writePath(this.nodes(), this.relationships());
        }
    }

    @Override
    public Comparison unsafeTernaryCompareTo(VirtualValue other, TernaryComparator<AnyValue> comparator) {
        return Comparison.from(this.unsafeCompareTo(other, comparator));
    }

    public String toString() {
        int i;
        NodeValue[] nodes = this.nodes();
        RelationshipValue[] relationships = this.relationships();
        StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
        for (i = 0; i < relationships.length; ++i) {
            sb.append(nodes[i]);
            sb.append(relationships[i]);
        }
        sb.append(nodes[i]);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public ListValue asList() {
        NodeValue[] nodes = this.nodes();
        RelationshipValue[] relationships = this.relationships();
        int size = nodes.length + relationships.length;
        ListValueBuilder builder = ListValueBuilder.newListBuilder(size);
        for (int i = 0; i < size; ++i) {
            if (i % 2 == 0) {
                builder.add(nodes[i / 2]);
                continue;
            }
            builder.add(relationships[i / 2]);
        }
        return builder.build();
    }

    static class DirectPathValue
    extends PathValue {
        private final NodeValue[] nodes;
        private final RelationshipValue[] edges;
        private final long payloadSize;

        DirectPathValue(NodeValue[] nodes, RelationshipValue[] edges, long payloadSize) {
            assert (nodes != null);
            assert (edges != null);
            assert (nodes.length == edges.length + 1);
            this.nodes = nodes;
            this.edges = edges;
            this.payloadSize = payloadSize;
        }

        @Override
        public final long startNodeId() {
            return this.nodes[0].id();
        }

        @Override
        public final long endNodeId() {
            return this.nodes[this.nodes.length - 1].id();
        }

        @Override
        public NodeValue startNode() {
            return this.nodes[0];
        }

        @Override
        public NodeValue endNode() {
            return this.nodes[this.nodes.length - 1];
        }

        @Override
        public NodeValue[] nodes() {
            return this.nodes;
        }

        @Override
        public RelationshipValue[] relationships() {
            return this.edges;
        }

        @Override
        public final int size() {
            return this.edges.length;
        }

        @Override
        public final long relationshipId(int index) {
            return this.edges[index].id();
        }

        @Override
        public int unsafeCompareTo(VirtualValue other, Comparator<AnyValue> comparator) {
            if (other instanceof DirectPathValue) {
                DirectPathValue otherPath = (DirectPathValue)other;
                NodeValue[] otherNodes = otherPath.nodes();
                RelationshipValue[] otherRelationships = otherPath.relationships();
                int x = this.nodes[0].unsafeCompareTo(otherNodes[0], comparator);
                if (x == 0) {
                    int length = Math.min(this.edges.length, otherRelationships.length);
                    for (int i = 0; x == 0 && i < length; ++i) {
                        x = this.edges[i].unsafeCompareTo(otherRelationships[i], comparator);
                    }
                    if (x == 0) {
                        x = Integer.compare(this.edges.length, otherRelationships.length);
                    }
                }
                return x;
            }
            return super.unsafeCompareTo(other, comparator);
        }

        @Override
        public boolean equals(VirtualValue other) {
            if (!(other instanceof DirectPathValue)) {
                return super.equals(other);
            }
            DirectPathValue that = (DirectPathValue)other;
            return this.size() == that.size() && this.startNodeId() == that.startNodeId() && Arrays.equals(this.edges, that.edges);
        }

        @Override
        protected int computeHashToMemoize() {
            int result = this.nodes[0].hashCode();
            int length = this.edges.length;
            for (int i = 0; i < length; ++i) {
                result += 31 * (result + this.edges[i].hashCode());
            }
            return result;
        }

        public long estimatedHeapUsage() {
            return DIRECT_PATH_SHALLOW_SIZE + this.payloadSize;
        }
    }
}

