/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.neo4j.fleetmanagement.communication.model.ErrorCode;
import com.neo4j.fleetmanagement.communication.model.ErrorResponse;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.utils.Logger;
import org.neo4j.logging.Log;

public class BaseService {
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected final ITransactor transactor;
    protected final Log userLog;
    protected final Logger pluginLog;
    protected final State state;

    public BaseService(ITransactor transactor) {
        this.transactor = transactor;
        this.userLog = Logger.getNeo4jLogger();
        this.pluginLog = Logger.getPluginLogger();
        this.state = State.getInstance();
    }

    void handleErrorResponse(String errMsgPrefix, int responseCode, byte[] responseBody) {
        if (responseBody == null || responseBody.length == 0) {
            String errorMsg = errMsgPrefix + " - Error response without body, code: " + responseCode;
            this.state.setDisconnected(errorMsg);
            this.userLog.error(errorMsg);
            return;
        }
        try {
            ErrorResponse errorResponse = (ErrorResponse)this.objectMapper.readValue(responseBody, ErrorResponse.class);
            if (errorResponse != null && errorResponse.code != 0) {
                this.handleValidErrorResponse(errMsgPrefix, errorResponse);
                return;
            }
            this.handleInvalidErrorResponse(errMsgPrefix, responseCode, responseBody, errorResponse);
        }
        catch (Exception e) {
            this.userLog.debug("Failed to parse error response", (Throwable)e);
            this.handleInvalidErrorResponse(errMsgPrefix, responseCode, responseBody, null);
        }
    }

    private void handleInvalidErrorResponse(String errMsgPrefix, int responseCode, byte[] responseBody, ErrorResponse errorResponse) {
        String errorMsg = "Unknown error response received: '" + new String(responseBody) + "' with code: " + responseCode;
        if (errorResponse != null && errorResponse.message != null) {
            errorMsg = "Error response: '" + errorResponse.message + "' with code: " + responseCode;
        }
        this.userLog.error(errMsgPrefix + " - " + errorMsg);
        this.state.setDisconnected(errorMsg);
    }

    private void handleValidErrorResponse(String errMsgPrefix, ErrorResponse errorResponse) {
        ErrorCode code = errorResponse.code();
        if (code == ErrorCode.TOKEN_ROTATION_DUE) {
            if (!State.getInstance().isRotatingToken()) {
                this.userLog.info(errMsgPrefix + " - " + String.valueOf(errorResponse));
                this.state.setDisconnected(code.getStatusMessage());
                this.transactor.rotateToken();
                this.state.setRotatingToken(true);
            }
        } else if (code == ErrorCode.TOKEN_EXPIRED) {
            this.userLog.error(errMsgPrefix + " - " + String.valueOf(errorResponse));
            this.transactor.deleteToken();
            this.state.setDisconnected(code.getStatusMessage());
        } else if (code == ErrorCode.TOKEN_REVOKED) {
            this.userLog.error(errMsgPrefix + " - " + String.valueOf(errorResponse));
            this.transactor.deleteToken();
            this.state.setDisconnected(code.getStatusMessage());
        } else if (code == ErrorCode.ACCESS_DENIED) {
            this.userLog.error(errMsgPrefix + " - " + String.valueOf(errorResponse));
            this.transactor.deleteToken();
            this.state.setDisconnected(code.getStatusMessage());
        } else {
            this.userLog.error(errMsgPrefix + " - Unknown error code in error response: " + String.valueOf(errorResponse));
            this.state.setDisconnected(errMsgPrefix + " - Unknown error code: " + String.valueOf((Object)errorResponse.code()));
        }
    }
}

