/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.communication.upstream;

import com.neo4j.fleetmanagement.communication.Helpers;
import com.neo4j.fleetmanagement.communication.upstream.ApiKeyProvider;
import com.neo4j.fleetmanagement.communication.upstream.ApiTokenGenerator;
import com.neo4j.fleetmanagement.configuration.State;
import com.neo4j.fleetmanagement.topology.TopologyMapper;
import com.neo4j.fleetmanagement.topology.model.Database;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.utils.TokenUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;
import org.neo4j.logging.Log;

public class Upstream {
    private static long maxTokenAge = 3540000L;
    private final String baseUrl;
    private final ITransactor transactor;
    private ApiKeyProvider.ApiKey apiKey;
    private ApiTokenGenerator apiTokenGenerator;
    private long generatedAt;
    private final Log userLog;
    private volatile String apiToken;

    public Upstream(ITransactor transactor, Log userLog) {
        String customBaseUrl = System.getenv("FLEET_MANAGEMENT_API_BASE_URL");
        this.baseUrl = Objects.requireNonNullElse(customBaseUrl, "https://fleet-management-api.neo4j.io/api/v1");
        this.transactor = transactor;
        this.userLog = userLog;
    }

    public void setToken(String token) throws IOException {
        if (token == null || token.isEmpty()) {
            this.apiToken = null;
        } else {
            ApiKeyProvider.ApiKey apiKey = TokenUtils.parseToken(token);
            ApiKeyProvider apiKeyProvider = new ApiKeyProvider(apiKey);
            this.apiTokenGenerator = new ApiTokenGenerator(apiKeyProvider);
            this.apiKey = apiKey;
            this.generateToken();
        }
    }

    private String getToken() {
        if (State.getInstance().isActive() && (this.apiToken == null || this.generatedAt + maxTokenAge < System.currentTimeMillis())) {
            this.generateToken();
        }
        return this.apiToken;
    }

    public ApiKeyProvider.ApiKey getApiKey() {
        return this.apiKey;
    }

    public void generateToken() {
        Date tokenExpiry = new Date(System.currentTimeMillis() + 3600000L);
        this.apiToken = this.apiTokenGenerator.generate(new ApiTokenGenerator.ApiTokenClaims("plugin", "plugin", "fleet-management-api", tokenExpiry, this.apiKey.projectId, this.getDbmsId()));
        this.generatedAt = System.currentTimeMillis();
    }

    public String getDbmsId() {
        Map<String, List<Database>> databasesByInstance = this.transactor.getDatabases();
        return TopologyMapper.getDbmsId(databasesByInstance);
    }

    public UpstreamPostRequest postTo(Endpoint endpoint) throws IOException {
        switch (endpoint) {
            case CONNECT: {
                return this.postTo("plugin/connect");
            }
            case REPORTING: {
                return this.postTo("plugin/report");
            }
            case METRICS: {
                return this.postTo("plugin/metrics");
            }
            case CONFIG: {
                return this.postTo("plugin/config");
            }
            case PING: {
                return this.postTo("plugin/ping");
            }
        }
        return null;
    }

    public boolean isReachable() {
        URL url;
        try {
            url = new URL(this.baseUrl);
        }
        catch (MalformedURLException e) {
            return false;
        }
        try (Socket soc = SSLSocketFactory.getDefault().createSocket();){
            soc.connect(new InetSocketAddress(url.getHost(), url.getDefaultPort()), 5000);
        }
        catch (UnknownHostException ex) {
            this.userLog.error("Fleet management plugin failed to reach the API - UnknownHostException: Please verify that the server can connect to a DNS server", new Object[]{ex.getMessage()});
            return false;
        }
        catch (IOException ex) {
            this.userLog.error("Fleet management plugin failed to reach the API - IOException: Consider checking the connection and if failures continue, try again later.", new Object[]{ex.getMessage()});
            return false;
        }
        catch (SecurityException ex) {
            this.userLog.error("Fleet management plugin failed to reach the API - SecurityException: A security manager exists and its checkConnect method doesn't allow connecting to the API.", new Object[]{ex.getMessage()});
            return false;
        }
        catch (IllegalArgumentException ex) {
            this.userLog.error("Fleet management plugin failed to reach the API - IllegalArgumentException: Please verify access to the public internet e.g., check your proxy settings and firewall rules.", new Object[]{ex.getMessage()});
            return false;
        }
        return true;
    }

    private UpstreamPostRequest postTo(String path) throws IOException {
        URL url = new URL(String.format("%s/%s", this.baseUrl, path));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Authorization", String.format("Bearer %s", this.getToken()));
        return new UpstreamPostRequest(conn);
    }

    public static enum Endpoint {
        REPORTING,
        METRICS,
        CONNECT,
        CONFIG,
        PING;

    }

    public static class UpstreamPostRequest {
        private final HttpURLConnection conn;

        private UpstreamPostRequest(HttpURLConnection conn) throws ProtocolException {
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            this.conn = conn;
        }

        public int transmit(byte[] data) throws IOException {
            try (OutputStream os = this.conn.getOutputStream();){
                os.write(data);
                os.flush();
            }
            catch (IOException e) {
                throw new IOException("Exception while writing request data: ", e);
            }
            try {
                return this.conn.getResponseCode();
            }
            catch (IOException e) {
                throw new IOException("Exception while getting error code: ", e);
            }
        }

        public byte[] getResponseBody() throws IOException {
            int responseCode = 0;
            try {
                responseCode = this.conn.getResponseCode();
            }
            catch (IOException e) {
                throw new IOException("Exception while getting the response code: ", e);
            }
            if (Helpers.responseOk(responseCode)) {
                try {
                    return this.conn.getInputStream().readAllBytes();
                }
                catch (IOException e) {
                    throw new IOException("Exception while reading response data: ", e);
                }
            }
            try {
                return this.conn.getErrorStream().readAllBytes();
            }
            catch (IOException e) {
                throw new IOException("Exception while reading error response data: ", e);
            }
        }
    }
}

