/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.topology;

import com.neo4j.fleetmanagement.bootstrap.Reflection;
import com.neo4j.fleetmanagement.topology.model.Database;
import com.neo4j.fleetmanagement.topology.model.Dbms;
import com.neo4j.fleetmanagement.topology.model.Server;
import com.neo4j.fleetmanagement.topology.packaginginformation.IPackagingInformation;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.transactions.model.VersionAndEdition;
import com.neo4j.fleetmanagement.utils.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.function.Predicates;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;

public class TopologyMapper {
    private final Config config;
    private final FileSystemAbstraction fs;
    private final ITransactor transactor;
    private final ServerIdentity serverIdentity;
    private final IPackagingInformation packagingInformation;
    private final Log userLog;
    private final Logger pluginLogger;
    private VersionAndEdition versionAndEdition;
    private List<Server.Plugin> plugins;

    public TopologyMapper(Config config, FileSystemAbstraction fs, ITransactor transactor, ServerIdentity serverIdentity) {
        this.config = config;
        this.fs = fs;
        this.transactor = transactor;
        this.serverIdentity = serverIdentity;
        this.userLog = Logger.getNeo4jLogger();
        this.pluginLogger = Logger.getPluginLogger();
        try {
            this.packagingInformation = Reflection.getNewInstanceOfImplementationOf(IPackagingInformation.class, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Dbms mapTopology() {
        Dbms dbms = new Dbms();
        dbms.packaging = this.packagingInformation.getPackaging(this.config, this.fs);
        dbms.serverId = this.serverIdentity.serverId().uuid().toString();
        if (this.versionAndEdition == null) {
            this.versionAndEdition = this.transactor.getVersionAndEdition();
        }
        dbms.edition = this.versionAndEdition.edition;
        if (this.plugins == null) {
            this.plugins = this.getPlugins(this.config);
        }
        Map<String, Server> instanceMap = this.transactor.getServers();
        Map<String, List<Database>> databasesByInstance = this.transactor.getDatabases();
        dbms.dbmsId = TopologyMapper.getDbmsId(databasesByInstance);
        databasesByInstance.forEach((serverId, dbArray) -> {
            if (!instanceMap.containsKey(serverId)) {
                this.userLog.warn("ServerId %s reported by database but not found in cluster", new Object[]{serverId});
                return;
            }
            ((Server)instanceMap.get((Object)serverId)).databases = dbArray;
        });
        dbms.servers = new ArrayList<Server>(instanceMap.values());
        Server thisServer = this.getThisServer(dbms);
        thisServer.plugins = this.plugins;
        if (thisServer.version == null) {
            thisServer.version = this.versionAndEdition.version;
        }
        thisServer.license = this.transactor.getLicense();
        try {
            thisServer.bloomLicense = this.transactor.getBloomLicense();
            thisServer.gdsLicense = this.transactor.getGdsLicense();
        }
        catch (Exception e) {
            this.userLog.warn("Failed to get optional license information: " + e.getMessage());
        }
        dbms.databases = databasesByInstance.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(entry -> entry.name).distinct().collect(Collectors.toList());
        thisServer.databases.forEach(db -> {
            if (!db.name.equals("system") && !db.isComposite() && db.currentStatus.equals("online")) {
                db.graphCount = this.transactor.getGraphCount(db.name);
            }
        });
        return dbms;
    }

    public String getDbmsId() {
        Map<String, List<Database>> databasesByInstance = this.transactor.getDatabases();
        return TopologyMapper.getDbmsId(databasesByInstance);
    }

    public String getServerId() {
        return this.serverIdentity.serverId().uuid().toString();
    }

    public String getServerVersion() {
        if (this.versionAndEdition == null) {
            this.versionAndEdition = this.transactor.getVersionAndEdition();
        }
        Map<String, Server> instanceMap = this.transactor.getServers();
        String thisServerVersion = null;
        for (Server server : instanceMap.values()) {
            if (!server.serverId.equals(this.getServerId())) continue;
            thisServerVersion = server.version;
        }
        if (thisServerVersion == null) {
            thisServerVersion = this.versionAndEdition.version;
        }
        return thisServerVersion;
    }

    public static String getDbmsId(Map<String, List<Database>> databasesByInstance) {
        String dbmsId = null;
        for (List<Database> dbList : databasesByInstance.values()) {
            for (Database oneDb : dbList) {
                if (dbmsId != null || !Objects.equals(oneDb.name, "system")) continue;
                dbmsId = oneDb.databaseId;
            }
        }
        return dbmsId;
    }

    private Server getThisServer(Dbms dbms) {
        for (Server server : dbms.servers) {
            if (!server.serverId.equals(dbms.serverId)) continue;
            return server;
        }
        throw new RuntimeException("Could not find this server in the topology");
    }

    private List<Server.Plugin> getPlugins(Config config) {
        ArrayList<Server.Plugin> arrayList;
        block18: {
            ArrayList<Server.Plugin> plugins = new ArrayList<Server.Plugin>();
            Stream<Path> list = Files.list((Path)config.get(GraphDatabaseSettings.plugin_dir));
            try {
                List jarPaths = list.filter(path -> path.toString().endsWith(".jar")).filter(Predicates.notNull()).collect(Collectors.toList());
                for (Path path2 : jarPaths) {
                    try (JarFile jarFile = new JarFile(path2.toFile());){
                        Server.Plugin plugin = new Server.Plugin();
                        plugins.add(plugin);
                        plugin.filename = path2.getFileName().toString();
                        this.pluginLogger.debug("Found plugin: " + String.valueOf(path2.getFileName()));
                        Manifest manifest = jarFile.getManifest();
                        if (manifest == null) {
                            this.pluginLogger.debug("No manifest found for plugin: " + String.valueOf(path2.getFileName()));
                            continue;
                        }
                        Attributes attrs = manifest.getMainAttributes();
                        plugin.name = attrs.getValue("Implementation-Title");
                        plugin.version = attrs.getValue("Implementation-Version");
                        plugin.vendor = attrs.getValue("Implementation-Vendor");
                    }
                    catch (IOException e) {
                        this.userLog.error("Failed to process plugin " + String.valueOf(path2.getFileName()), (Throwable)e);
                    }
                }
                arrayList = plugins;
                if (list == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.userLog.error("Failed to read plugin directory", (Throwable)e);
                    return plugins;
                }
            }
            list.close();
        }
        return arrayList;
    }
}

