/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.transactions;

import com.neo4j.fleetmanagement.topology.model.Database;
import com.neo4j.fleetmanagement.topology.model.GraphCount;
import com.neo4j.fleetmanagement.topology.model.Server;
import com.neo4j.fleetmanagement.transactions.ITransactor;
import com.neo4j.fleetmanagement.transactions.editions.v5_CommunityTransactor;
import com.neo4j.fleetmanagement.transactions.editions.v5_EnterpriseTransactor;
import com.neo4j.fleetmanagement.transactions.model.VersionAndEdition;
import java.util.List;
import java.util.Map;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.kernel.impl.factory.DbmsInfo;

public class v5_Transactor
implements ITransactor {
    private final ITransactor editionTransactor;

    public v5_Transactor() {
        this.editionTransactor = null;
    }

    public v5_Transactor(DbmsInfo dbmsInfo, ServerIdentity serverIdentity) {
        if (dbmsInfo == null) {
            throw new IllegalArgumentException("dbmsInfo cannot be null");
        }
        if (dbmsInfo.equals((Object)DbmsInfo.ENTERPRISE)) {
            this.editionTransactor = new v5_EnterpriseTransactor();
        } else if (dbmsInfo.equals((Object)DbmsInfo.COMMUNITY)) {
            this.editionTransactor = new v5_CommunityTransactor(serverIdentity);
        } else {
            throw new IllegalArgumentException("unsupported dbms edition: " + String.valueOf(dbmsInfo));
        }
    }

    @Override
    public void init(DatabaseManagementService databaseManagementService) {
        this.editionTransactor.init(databaseManagementService);
    }

    @Override
    public boolean getTokenStatus() {
        return this.editionTransactor.getTokenStatus();
    }

    @Override
    public boolean getTokenRotationStatus() {
        return this.editionTransactor.getTokenRotationStatus();
    }

    @Override
    public String getToken() {
        return this.editionTransactor.getToken();
    }

    @Override
    public VersionAndEdition getVersionAndEdition() {
        return this.editionTransactor.getVersionAndEdition();
    }

    @Override
    public Map<String, Server> getServers() {
        return this.editionTransactor.getServers();
    }

    @Override
    public Map<String, List<Database>> getDatabases() {
        return this.editionTransactor.getDatabases();
    }

    @Override
    public Server.License getLicense() {
        return this.editionTransactor.getLicense();
    }

    @Override
    public Server.License getGdsLicense() {
        return this.editionTransactor.getGdsLicense();
    }

    @Override
    public Server.License getBloomLicense() {
        return this.editionTransactor.getBloomLicense();
    }

    @Override
    public GraphCount getGraphCount(String databaseName) {
        return this.editionTransactor.getGraphCount(databaseName);
    }

    @Override
    public void setToken(String token) {
        this.editionTransactor.setToken(token);
    }

    @Override
    public void rotateToken() {
        assert (this.editionTransactor != null);
        this.editionTransactor.rotateToken();
    }

    @Override
    public void deleteToken() {
        assert (this.editionTransactor != null);
        this.editionTransactor.deleteToken();
    }
}

