/*
 * Decompiled with CFR 0.152.
 */
package com.neo4j.fleetmanagement.utils;

import org.neo4j.logging.Log;

public class Logger {
    private final Log log;
    private static Logger instance;
    private static boolean payloadLoggingEnabled;
    private static boolean debugEnabled;

    private Logger(Log log) {
        this.log = log;
    }

    public static synchronized void initLogger(Log log) {
        if (instance != null) {
            throw new IllegalStateException("Logger has already been initialized.");
        }
        instance = new Logger(log);
    }

    public static synchronized Log getNeo4jLogger() {
        if (instance == null) {
            throw new IllegalStateException("Logger has not been initialized. Call initLogger first.");
        }
        return Logger.instance.log;
    }

    public static synchronized Logger getPluginLogger() {
        if (instance == null) {
            throw new IllegalStateException("Logger has not been initialized. Call initLogger first.");
        }
        return instance;
    }

    public static void setDebugEnabled(Boolean enabled) {
        debugEnabled = Boolean.TRUE.equals(enabled);
    }

    public static void setPayloadLoggingEnabled(Boolean enabled) {
        payloadLoggingEnabled = Boolean.TRUE.equals(enabled);
    }

    public void debug(String message) {
        if (debugEnabled) {
            this.log.info(message);
        }
    }

    public void payload(String message) {
        if (payloadLoggingEnabled) {
            this.log.info(message);
        }
    }

    static {
        payloadLoggingEnabled = false;
        debugEnabled = false;
    }
}

