/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.jdbc.ConnectionImpl;
import org.neo4j.jdbc.Lazy;
import org.neo4j.jdbc.LocalStatementImpl;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.Neo4jConversions;
import org.neo4j.jdbc.Neo4jDatabaseMetaData;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.Neo4jTransaction;
import org.neo4j.jdbc.ProductVersion;
import org.neo4j.jdbc.UncheckedSQLException;
import org.neo4j.jdbc.translator.spi.View;
import org.neo4j.jdbc.values.Record;
import org.neo4j.jdbc.values.Type;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

final class DatabaseMetadataImpl
implements Neo4jDatabaseMetaData {
    private static final Properties QUERIES = new Properties();
    private static final String COL_TABLE_NAME = "TABLE_NAME";
    private static final String COL_TABLE_CAT = "TABLE_CAT";
    private static final String COL_TABLE_SCHEM = "TABLE_SCHEM";
    private static final String COL_COLUMN_NAME = "COLUMN_NAME";
    private static final String COL_GRANTOR = "GRANTOR";
    private static final String COL_GRANTEE = "GRANTEE";
    private static final String COL_PRIVILEGE = "PRIVILEGE";
    private static final String COL_IS_GRANTABLE = "IS_GRANTABLE";
    private static final String COL_SCOPE = "SCOPE";
    private static final String COL_DATA_TYPE = "DATA_TYPE";
    private static final String COL_TYPE_NAME = "TYPE_NAME";
    private static final String COL_COLUMN_SIZE = "COLUMN_SIZE";
    private static final String COL_BUFFER_LENGTH = "BUFFER_LENGTH";
    private static final String COL_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    private static final String COL_PSEUDO_COLUMN = "PSEUDO_COLUMN";
    private static final String COL_TABLE_CATALOG = "TABLE_CATALOG";
    private static final String COL_KEY_SEQ = "KEY_SEQ";
    private static final String COL_PK_NAME = "PK_NAME";
    private static final String COL_PKTABLE_CAT = "PKTABLE_CAT";
    private static final String COL_PKTABLE_SCHEM = "PKTABLE_SCHEM";
    private static final String COL_PKTABLE_NAME = "PKTABLE_NAME";
    private static final String COL_PKCOLUMN_NAME = "PKCOLUMN_NAME";
    private static final String COL_FKTABLE_CAT = "FKTABLE_CAT";
    private static final String COL_FKTABLE_SCHEM = "FKTABLE_SCHEM";
    private static final String COL_FKTABLE_NAME = "FKTABLE_NAME";
    private static final String COL_FKCOLUMN_NAME = "FKCOLUMN_NAME";
    private static final String COL_UPDATE_RULE = "UPDATE_RULE";
    private static final String COL_DELETE_RULE = "DELETE_RULE";
    private static final String COL_FK_NAME = "FK_NAME";
    private static final String COL_DEFERRABILITY = "DEFERRABILITY";
    private static final String COL_PRECISION = "PRECISION";
    private static final String COL_LITERAL_PREFIX = "LITERAL_PREFIX";
    private static final String COL_LITERAL_SUFFIX = "LITERAL_SUFFIX";
    private static final String COL_CREATE_PARAMS = "CREATE_PARAMS";
    private static final String COL_AUTO_INCREMENT = "AUTO_INCREMENT";
    private static final String COL_SQL_DATETIME_SUB = "SQL_DATETIME_SUB";
    private static final String COL_FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    private static final String COL_UNSIGNED_ATTRIBUTE = "UNSIGNED_ATTRIBUTE";
    private static final String COL_MAXIMUM_SCALE = "MAXIMUM_SCALE";
    private static final String COL_SQL_DATA_TYPE = "SQL_DATA_TYPE";
    private static final String COL_NUM_PREC_RADIX = "NUM_PREC_RADIX";
    private static final String COL_LOCAL_TYPE_NAME = "LOCAL_TYPE_NAME";
    private static final String COL_NULLABLE = "NULLABLE";
    private static final String COL_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String COL_MINIMUM_SCALE = "MINIMUM_SCALE";
    private static final String COL_SEARCHABLE = "SEARCHABLE";
    private static final String COL_TYPE_SCHEM = "TYPE_SCHEM";
    private static final String COL_TYPE_CAT = "TYPE_CAT";
    private static final String COL_SUPERTYPE_CAT = "SUPERTYPE_CAT";
    private static final String COL_SUPERTYPE_SCHEM = "SUPERTYPE_SCHEM";
    private static final String COL_SUPERTYPE_NAME = "SUPERTYPE_NAME";
    private static final String COL_SUPERTABLE_NAME = "SUPERTABLE_NAME";
    private static final String COL_ATTR_SIZE = "ATTR_SIZE";
    private static final String COL_SCOPE_SCHEMA = "SCOPE_SCHEMA";
    private static final String COL_SCOPE_TABLE = "SCOPE_TABLE";
    private static final String COL_CHAR_OCTET_LENGTH = "CHAR_OCTET_LENGTH";
    private static final String COL_SOURCE_DATA_TYPE = "SOURCE_DATA_TYPE";
    private static final String COL_ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String COL_IS_NULLABLE = "IS_NULLABLE";
    private static final String COL_REMARKS = "REMARKS";
    private static final String COL_ATTR_NAME = "ATTR_NAME";
    private static final String COL_ATTR_TYPE_NAME = "ATTR_TYPE_NAME";
    private static final String COL_SCOPE_CATALOG = "SCOPE_CATALOG";
    private static final String COL_ATTR_DEF = "ATTR_DEF";
    private static final String COL_COLUMN_USAGE = "COLUMN_USAGE";
    private static final String DEFAULT_SCHEMA = "public";
    private static final List<String> NUMERIC_FUNCTIONS;
    private static final List<String> STRING_FUNCTIONS;
    private static final List<String> TIME_DATE_FUNCTIONS;
    private static final List<ClientInfoProperty> SUPPORTED_CLIENT_INFO_PROPERTIES;
    private static final Logger LOGGER;
    private final Connection connection;
    private final boolean automaticSqlTranslation;
    private final int relationshipSampleSize;
    private final Lazy<Boolean> apocAvailable;
    private final Lazy<String> userName;
    private final Lazy<Boolean> readOnly;
    private final Map<GetTablesCacheKey, GetTablesCacheValue> tablesCache = new ConcurrentHashMap<GetTablesCacheKey, GetTablesCacheValue>();
    private final Map<String, View> views;

    DatabaseMetadataImpl(Connection connection, boolean automaticSqlTranslation, int relationshipSampleSize, Collection<View> views) {
        this.connection = connection;
        this.automaticSqlTranslation = automaticSqlTranslation;
        this.relationshipSampleSize = relationshipSampleSize;
        this.apocAvailable = Lazy.of(this::isApocAvailable0);
        this.userName = Lazy.of(() -> {
            Neo4jTransaction.PullResponse response = this.doQueryForPullResponse(DatabaseMetadataImpl.getRequest("getUserName", new Object[0]));
            return response.records().get(0).get(0).asString();
        });
        this.readOnly = Lazy.of(() -> {
            Neo4jTransaction.PullResponse response = this.doQueryForPullResponse(DatabaseMetadataImpl.getRequest("isReadOnly", "name", this.getSingleCatalog()));
            return response.records().get(0).get(0).asBoolean();
        });
        this.views = views.stream().collect(Collectors.toMap(View::name, Function.identity(), (v1, v2) -> {
            throw new IllegalArgumentException("Duplicate name for Cypher-backed view " + String.valueOf(v1));
        }, TreeMap::new));
    }

    boolean isApocAvailable() {
        return this.apocAvailable.resolve();
    }

    private boolean isApocAvailable0() {
        try {
            Neo4jTransaction.PullResponse response = this.doQueryForPullResponse(new Request("SHOW FUNCTIONS YIELD name WHERE name = 'apoc.version' RETURN count(*) >= 1 AS available", Map.of()));
            List<Record> records = response.records();
            return records.size() == 1 && records.get(0).get("available").asBoolean();
        }
        catch (SQLException ex) {
            return false;
        }
    }

    static Request getRequest(String queryName, Object ... keyAndValues) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        for (int i = 0; i < keyAndValues.length; i += 2) {
            args.put((String)keyAndValues[i], keyAndValues[i + 1]);
        }
        return new Request(QUERIES.getProperty(queryName), args);
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        Neo4jTransaction.PullResponse response = this.doQueryForPullResponse(DatabaseMetadataImpl.getRequest("allProceduresAreCallable", new Object[0]));
        ArrayList<String> executableProcedures = new ArrayList<String>();
        for (Record record : response.records()) {
            executableProcedures.add(record.get(0).asString());
        }
        if (executableProcedures.isEmpty()) {
            return false;
        }
        try (ResultSet proceduresResultSet = this.getProcedures(null, null, null);){
            while (proceduresResultSet.next()) {
                if (executableProcedures.contains(proceduresResultSet.getString(3))) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.connection.unwrap(Neo4jConnection.class).getDatabaseURL().toString();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.userName.resolveThrowing(SQLException.class);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly.resolveThrowing(SQLException.class);
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return true;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        Neo4jTransaction.PullResponse response = this.doQueryForPullResponse(DatabaseMetadataImpl.getRequest("getDatabaseProductName", new Object[0]));
        Record record = response.records().get(0);
        return "%s-%s-%s".formatted(record.get(0).asString(), record.get(1).asString(), record.get(2).asString());
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        Neo4jTransaction.PullResponse response = this.doQueryForPullResponse(DatabaseMetadataImpl.getRequest("getDatabaseProductVersion", new Object[0]));
        return response.records().get(0).get(0).asString();
    }

    @Override
    public String getDriverName() {
        return "Neo4j JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return ProductVersion.getValue();
    }

    @Override
    public int getDriverMajorVersion() {
        return ProductVersion.getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return ProductVersion.getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "`";
    }

    @Override
    public String getSQLKeywords() {
        return "";
    }

    @Override
    public String getNumericFunctions() {
        return String.join((CharSequence)",", NUMERIC_FUNCTIONS);
    }

    @Override
    public String getStringFunctions() {
        return String.join((CharSequence)",", STRING_FUNCTIONS);
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        ArrayList<String> functions = new ArrayList<String>();
        try (ResultSet rs = this.getFunctions(null, null, null);){
            while (rs.next()) {
                functions.add(rs.getString("FUNCTION_NAME"));
            }
        }
        return String.join((CharSequence)",", functions);
    }

    @Override
    public String getTimeDateFunctions() {
        return String.join((CharSequence)",", TIME_DATE_FUNCTIONS);
    }

    @Override
    public String getSearchStringEscape() {
        return "'";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        LOGGER.log(Level.FINE, "supportsConvert returns false for now, that might change in the future.");
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        LOGGER.log(Level.FINE, "supportsConvert returns false for now, that might change in the future.");
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return this.automaticSqlTranslation;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return this.automaticSqlTranslation;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return this.automaticSqlTranslation;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        if (this.automaticSqlTranslation) {
            LOGGER.log(Level.FINE, "supportsExtendedSQLGrammar returns false for now despite automatic sql translation being on, that might change in the future.");
        }
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return this.automaticSqlTranslation;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        if (this.automaticSqlTranslation) {
            LOGGER.log(Level.FINE, "supportsANSI92IntermediateSQL returns false for now despite automatic sql translation being on, that might change in the future.");
        }
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        if (this.automaticSqlTranslation) {
            LOGGER.log(Level.FINE, "supportsANSI92FullSQL returns false for now despite automatic sql translation being on, that might change in the future.");
        }
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return this.automaticSqlTranslation;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return this.automaticSqlTranslation;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public String getSchemaTerm() {
        return "schema";
    }

    @Override
    public String getProcedureTerm() {
        return "procedure";
    }

    @Override
    public String getCatalogTerm() {
        return "database";
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        Neo4jTransaction.PullResponse response = this.doQueryForPullResponse(DatabaseMetadataImpl.getRequest("getMaxConnections", new Object[0]));
        if (response.records().isEmpty()) {
            return 0;
        }
        Record record = response.records().get(0);
        return record.get(0).asInt();
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 63;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 65535;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 2;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 0 || level == 2;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        Request request = DatabaseMetadataImpl.getRequest("getProcedures", "name", procedureNamePattern, "procedureType", 0, "catalogAsParameterWorkaround", this.getSingleCatalog());
        return this.doQueryForResultSet(request);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        List<Map<String, Object>> intermediateResults = this.getArgumentDescriptions("PROCEDURES", procedureNamePattern);
        Request request = DatabaseMetadataImpl.getRequest("getProcedureColumns", "results", intermediateResults, "columnNamePattern", columnNamePattern, "columnType", 1, "nullable", 2, "catalogAsParameterWorkaround", this.getSingleCatalog(), "returnType", 3);
        return this.doQueryForResultSet(request);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        this.assertCatalogIsNullOrEmpty(catalog);
        try {
            GetTablesCacheKey key = new GetTablesCacheKey(catalog, schemaPattern, tableNamePattern, types);
            GetTablesCacheValue result = this.tablesCache.computeIfAbsent(key, this::getTables0);
            return new LocalStatementImpl(this.connection, result.runResponse, result.pullResponse).getResultSet();
        }
        catch (UncheckedSQLException ex) {
            throw ex.getCause();
        }
    }

    private GetTablesCacheValue getTables0(GetTablesCacheKey key) {
        GetTablesCacheValue getTablesCacheValue;
        block8: {
            String tableNamePattern = key.tableNamePattern();
            String[] types = key.types();
            Request request = DatabaseMetadataImpl.getRequest(this.isApocAvailable() ? "getTablesApoc" : "getTablesFallback", "name", tableNamePattern != null ? tableNamePattern.replace("%", ".*") : null, "sampleSize", this.relationshipSampleSize, "types", types, "views", this.views.keySet());
            ResultSet resultSet = this.doQueryForResultSet(request);
            try {
                getTablesCacheValue = GetTablesCacheValue.of(resultSet);
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new UncheckedSQLException(ex);
                }
            }
            resultSet.close();
        }
        return getTablesCacheValue;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.doQueryForResultSet(DatabaseMetadataImpl.getRequest("getCatalogs", new Object[0]));
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("TABLE_TYPE");
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.staticPullResponseFor(keys, List.of(new Value[]{Values.value("TABLE")}, new Value[]{Values.value("RELATIONSHIP")}, new Value[]{Values.value("CBV")}));
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    static Value getMaxPrecision(int type) {
        if (type == -5) {
            return Values.value(19);
        }
        if (type == 4) {
            return Values.value(10);
        }
        if (type == 8) {
            return Values.value(15);
        }
        return Values.NULL;
    }

    private Stream<Map<String, String>> getViewColumns() {
        return this.views.values().stream().flatMap(view -> view.columns().stream().map(column -> Map.of("viewName", view.name(), "propertyName", column.name(), "propertyType", column.type())));
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        columnNamePattern = columnNamePattern != null ? columnNamePattern.replace("%", ".*") : columnNamePattern;
        Request request = DatabaseMetadataImpl.getRequest("getColumns", "name", tableNamePattern != null ? tableNamePattern.replace("%", ".*") : tableNamePattern, "column_name", columnNamePattern, "sampleSize", this.relationshipSampleSize, "viewColumns", this.getViewColumns());
        Neo4jTransaction.PullResponse innerColumnsResponse = this.doQueryForPullResponse(request);
        List<Record> records = innerColumnsResponse.records();
        LinkedList<Value[]> rows = new LinkedList<Value[]>();
        HashMap<Value, Set> columnPerLabel = new HashMap<Value, Set>();
        HashSet<Value> cbvs = new HashSet<Value>();
        for (Record record : records) {
            Value nodeLabels;
            Value propertyName = record.get(1);
            Value propertyTypes = record.get(2);
            if (propertyName.isNull() || propertyTypes.isNull()) continue;
            Value labelsOrTypes = nodeLabels = record.get(0);
            String tableType = record.get("TABLE_TYPE").asString();
            if ("RELATIONSHIP".equals(tableType)) {
                labelsOrTypes = Values.value(List.of(record.get("relationshipType").asString()));
            }
            List<Value> propertyTypeList = propertyTypes.asList(propertyType -> propertyType);
            Value propertyType2 = DatabaseMetadataImpl.getTypeFromList(propertyTypeList, propertyName.asString());
            int NULLABLE = 1;
            String IS_NULLABLE = "YES";
            Request innerRequest = DatabaseMetadataImpl.getRequest("getColumns.nullability", "nodeLabels", labelsOrTypes, "propertyName", propertyName);
            try (ResultSet result = this.doQueryForResultSet(innerRequest);){
                result.next();
                if (result.getBoolean(1)) {
                    NULLABLE = 0;
                    IS_NULLABLE = "NO";
                }
            }
            List nodeLabelList = nodeLabels.asList(Function.identity());
            for (Value nodeLabel : nodeLabelList) {
                Set properties = columnPerLabel.computeIfAbsent(nodeLabel, i -> new HashSet());
                if (properties.contains(propertyName)) continue;
                properties.add(propertyName);
                ArrayList<Value> values = this.addColumn(nodeLabel, propertyName, propertyType2, NULLABLE, IS_NULLABLE, nodeLabelList.indexOf(nodeLabel) + 1, false);
                rows.add((Value[])values.toArray(Value[]::new));
                if (!"CBV".equals(tableType)) continue;
                cbvs.add(nodeLabel);
            }
        }
        if (columnPerLabel.isEmpty()) {
            ResultSet tables = this.getTables(catalog, schemaPattern, tableNamePattern, null);
            while (tables.next()) {
                columnPerLabel.put(tables.getObject(COL_TABLE_NAME, Value.class), new HashSet());
            }
        }
        for (Value v : columnPerLabel.keySet()) {
            ResultSet result;
            if (cbvs.contains(v)) continue;
            boolean isRelationship = v.asString().contains("_");
            ArrayList<String> additionalIds = new ArrayList<String>(List.of("v$id"));
            if (isRelationship && (result = this.getTables(null, null, v.asString(), new String[]{"RELATIONSHIP"})).next()) {
                String[] definition = result.getString(COL_REMARKS).split("\n");
                additionalIds.add("v$" + definition[0].toLowerCase(Locale.ROOT) + "_id");
                additionalIds.add("v$" + definition[2].toLowerCase(Locale.ROOT) + "_id");
            }
            for (String additionalId : additionalIds) {
                if (columnNamePattern != null && !additionalId.matches(columnNamePattern.replace("%", ".*"))) continue;
                ArrayList<Value> values = this.addColumn(v, Values.value(additionalId), Values.value("String"), 0, "NO", 0, true);
                rows.add(0, (Value[])values.toArray(Value[]::new));
            }
        }
        List<String> keys = DatabaseMetadataImpl.getKeysForGetColumns();
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.staticPullResponseFor(keys, rows);
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    private ArrayList<Value> addColumn(Value nodeLabel, Value propertyName, Value propertyType, int NULLABLE, String IS_NULLABLE, Integer ordinalPosition, boolean generated) throws SQLException {
        ArrayList<Value> values = new ArrayList<Value>();
        values.add(Values.value(this.getSingleCatalog()));
        values.add(Values.value(DEFAULT_SCHEMA));
        values.add(nodeLabel);
        values.add(propertyName);
        int columnType = Neo4jConversions.toSqlTypeFromOldCypherType(propertyType.asString());
        values.add(Values.value(columnType));
        values.add(Values.value(Neo4jConversions.oldCypherTypesToNew(propertyType.asString())));
        values.add(DatabaseMetadataImpl.getMaxPrecision(columnType));
        values.add(Values.NULL);
        values.add(Values.NULL);
        values.add(Values.value(2));
        values.add(Values.value(NULLABLE));
        values.add(Values.NULL);
        values.add(Values.NULL);
        values.add(Values.NULL);
        values.add(Values.NULL);
        values.add(Values.NULL);
        values.add(Values.value(ordinalPosition));
        values.add(Values.value(IS_NULLABLE));
        values.add(Values.NULL);
        values.add(Values.NULL);
        values.add(Values.NULL);
        values.add(Values.NULL);
        values.add(Values.value("NO"));
        values.add(Values.value(generated ? "YES" : "NO"));
        return values;
    }

    static Neo4jTransaction.PullResponse staticPullResponseFor(final List<String> keys, final List<Value[]> rows) {
        return new Neo4jTransaction.PullResponse(){

            @Override
            public List<Record> records() {
                ArrayList<Record> records = new ArrayList<Record>(rows.size());
                for (Value[] values : rows) {
                    records.add(Record.of(keys, values));
                }
                return records;
            }

            @Override
            public Optional<Neo4jTransaction.ResultSummary> resultSummary() {
                return Optional.empty();
            }

            @Override
            public boolean hasMore() {
                return false;
            }
        };
    }

    static ResultSet resultSetForParameters(Connection connection, Map<String, Object> parameters) throws SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        Value[] columns = new Value[parameters.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            Value value;
            String k = entry.getKey();
            Object v = entry.getValue();
            keys.add(k);
            columns[i++] = v instanceof Value ? (value = (Value)v) : Values.value(v);
        }
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.staticPullResponseFor(keys, List.of(columns));
        return new LocalStatementImpl(connection, runResponse, pullResponse).getResultSet();
    }

    private static Value getTypeFromList(List<Value> types, String propertyName) {
        if (types.size() > 1) {
            LOGGER.log(Level.FINE, "More than one property type found for property {0}, api will still return first one found.", propertyName);
            for (Value propertyType : types) {
                if (!propertyType.asString().toUpperCase(Locale.ROOT).startsWith("STRING")) continue;
                return propertyType;
            }
            return Values.value("Any");
        }
        return types.get(0);
    }

    private static List<String> getKeysForGetColumns() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(COL_TABLE_CAT);
        keys.add(COL_TABLE_SCHEM);
        keys.add(COL_TABLE_NAME);
        keys.add(COL_COLUMN_NAME);
        keys.add(COL_DATA_TYPE);
        keys.add(COL_TYPE_NAME);
        keys.add(COL_COLUMN_SIZE);
        keys.add(COL_BUFFER_LENGTH);
        keys.add(COL_DECIMAL_DIGITS);
        keys.add(COL_NUM_PREC_RADIX);
        keys.add(COL_NULLABLE);
        keys.add(COL_REMARKS);
        keys.add("COLUMN_DEF");
        keys.add(COL_SQL_DATA_TYPE);
        keys.add(COL_SQL_DATETIME_SUB);
        keys.add(COL_CHAR_OCTET_LENGTH);
        keys.add(COL_ORDINAL_POSITION);
        keys.add(COL_IS_NULLABLE);
        keys.add(COL_SCOPE_CATALOG);
        keys.add(COL_SCOPE_SCHEMA);
        keys.add(COL_SCOPE_TABLE);
        keys.add(COL_SOURCE_DATA_TYPE);
        keys.add("IS_AUTOINCREMENT");
        keys.add("IS_GENERATEDCOLUMN");
        return keys;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schema);
        List<String> keys = List.of(COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_COLUMN_NAME, COL_GRANTOR, COL_GRANTEE, COL_PRIVILEGE, COL_IS_GRANTABLE);
        return this.emptyResultSet(keys);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        List<String> keys = List.of(COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_GRANTOR, COL_GRANTEE, COL_PRIVILEGE, COL_IS_GRANTABLE);
        return this.emptyResultSet(keys);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schema);
        List<String> keys = List.of(COL_SCOPE, COL_COLUMN_NAME, COL_DATA_TYPE, COL_TYPE_NAME, COL_COLUMN_SIZE, COL_BUFFER_LENGTH, COL_DECIMAL_DIGITS, COL_PSEUDO_COLUMN);
        return this.emptyResultSet(keys);
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schema);
        List<String> keys = List.of(COL_SCOPE, COL_COLUMN_NAME, COL_DATA_TYPE, COL_TYPE_NAME, COL_COLUMN_SIZE, COL_BUFFER_LENGTH, COL_DECIMAL_DIGITS, COL_PSEUDO_COLUMN);
        return this.emptyResultSet(keys);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schema);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(COL_TABLE_CATALOG);
        keys.add(COL_TABLE_SCHEM);
        keys.add(COL_TABLE_NAME);
        keys.add(COL_COLUMN_NAME);
        keys.add(COL_KEY_SEQ);
        keys.add(COL_PK_NAME);
        List<Object> resultRows = List.of();
        if (table != null) {
            String finalTable = table;
            boolean relationshipChecked = false;
            if (table.matches(".+?_.+?_.+?")) {
                ResultSet relationships = this.getTables(catalog, schema, table, new String[]{"RELATIONSHIP"});
                if (relationships.next()) {
                    relationshipChecked = true;
                    finalTable = relationships.getString(COL_REMARKS).split("\n")[1].trim();
                }
                relationships.close();
            }
            Request request = DatabaseMetadataImpl.getRequest("getPrimaryKeys", "name", finalTable);
            Neo4jTransaction.PullResponse pullResponse = this.doQueryForPullResponse(request);
            List<Record> records = pullResponse.records();
            ArrayList<UniqueConstraint> uniqueConstraints = new ArrayList<UniqueConstraint>();
            for (Record record : records) {
                uniqueConstraints.add(new UniqueConstraint(record.get("name").asString(), record.get("labelsOrTypes").asList(Value::asString), record.get("properties").asList(Value::asString)));
            }
            if (uniqueConstraints.size() == 1) {
                resultRows = DatabaseMetadataImpl.makeUniqueKeyValues(this.getSingleCatalog(), DEFAULT_SCHEMA, table, uniqueConstraints);
            } else {
                boolean exists = relationshipChecked;
                if (!exists) {
                    ResultSet tables = this.getTables(catalog, schema, table, new String[]{"TABLE"});
                    exists = tables.next();
                    tables.close();
                }
                resultRows = exists ? DatabaseMetadataImpl.makeUniqueKeyValues(this.getSingleCatalog(), DEFAULT_SCHEMA, table, List.of(new UniqueConstraint(table + "_elementId", List.of(table), List.of("v$id")))) : List.of();
            }
        }
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.staticPullResponseFor(keys, resultRows);
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    private static List<Value[]> makeUniqueKeyValues(String catalog, String schema, String table, List<UniqueConstraint> uniqueConstraints) {
        ArrayList<Value[]> results = new ArrayList<Value[]>();
        for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
            for (int i = 0; i < uniqueConstraint.properties.size(); ++i) {
                results.add(new Value[]{Values.value(catalog), Values.value(schema), Values.value(table), Values.value(uniqueConstraint.properties.get(i)), Values.value(i + 1), Values.value(uniqueConstraint.name)});
            }
        }
        return results;
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.createEmptyKeysResult(catalog, schema);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.createEmptyKeysResult(catalog, schema);
    }

    private ResultSet createEmptyKeysResult(String catalog, String schema) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schema);
        ArrayList<String> keys = new ArrayList<String>();
        return this.createKeysResultSet(keys);
    }

    private ResultSet createKeysResultSet(ArrayList<String> keys) throws SQLException {
        keys.add(COL_PKTABLE_CAT);
        keys.add(COL_PKTABLE_SCHEM);
        keys.add(COL_PKTABLE_NAME);
        keys.add(COL_PKCOLUMN_NAME);
        keys.add(COL_FKTABLE_CAT);
        keys.add(COL_FKTABLE_SCHEM);
        keys.add(COL_FKTABLE_NAME);
        keys.add(COL_FKCOLUMN_NAME);
        keys.add(COL_KEY_SEQ);
        keys.add(COL_UPDATE_RULE);
        keys.add(COL_DELETE_RULE);
        keys.add(COL_FK_NAME);
        keys.add(COL_PK_NAME);
        keys.add(COL_DEFERRABILITY);
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.createEmptyPullResponse();
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.assertCatalogIsNullOrEmpty(parentCatalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(parentSchema);
        this.assertCatalogIsNullOrEmpty(foreignCatalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(foreignSchema);
        List<String> keys = List.of(COL_PKTABLE_CAT, COL_PKTABLE_SCHEM, COL_PKTABLE_NAME, COL_PKCOLUMN_NAME, COL_FKTABLE_CAT, COL_FKTABLE_SCHEM, COL_FKTABLE_NAME, COL_FKCOLUMN_NAME, COL_KEY_SEQ, COL_UPDATE_RULE, COL_DELETE_RULE, COL_FK_NAME, COL_PK_NAME, COL_DEFERRABILITY);
        return this.emptyResultSet(keys);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        List<String> keys = List.of(COL_TYPE_NAME, COL_DATA_TYPE, COL_PRECISION, COL_LITERAL_PREFIX, COL_LITERAL_SUFFIX, COL_CREATE_PARAMS, COL_NULLABLE, COL_CASE_SENSITIVE, COL_SEARCHABLE, COL_UNSIGNED_ATTRIBUTE, COL_FIXED_PREC_SCALE, COL_AUTO_INCREMENT, COL_LOCAL_TYPE_NAME, COL_MINIMUM_SCALE, COL_MAXIMUM_SCALE, COL_SQL_DATA_TYPE, COL_SQL_DATETIME_SUB, COL_NUM_PREC_RADIX);
        ArrayList<Value[]> values = new ArrayList<Value[]>();
        for (Type type : Type.values()) {
            int sqlType = Neo4jConversions.toSqlType(type);
            int columnSearchable = type == Type.STRING ? 3 : (type != Type.RELATIONSHIP ? 2 : 0);
            Value[] row = new Value[]{Values.value(type.name()), Values.value(sqlType), DatabaseMetadataImpl.getMaxPrecision(sqlType), Values.NULL, Values.NULL, Values.NULL, Values.value(1), Values.value(type == Type.STRING), Values.value(columnSearchable), Values.value(false), Values.value(false), Values.NULL, Values.NULL, Values.NULL, Values.NULL, Values.NULL, Values.NULL, Values.value(10)};
            values.add(row);
        }
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.staticPullResponseFor(keys, values);
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schema);
        ArrayList<Map<String, Value>> intermediateResults = new ArrayList<Map<String, Value>>();
        Request request = DatabaseMetadataImpl.getRequest("getIndexInfo", "name", table, "unique", unique);
        try (ResultSet rs = this.doQueryForResultSet(request);){
            while (rs.next()) {
                intermediateResults.add(Map.of("name", rs.getString("name"), "tableName", rs.getObject("labelsOrTypes", Value.class).asList().get(0), "properties", rs.getObject("properties"), "owningConstraint", rs.getObject("owningConstraint", Value.class)));
            }
        }
        return this.doQueryForResultSet(DatabaseMetadataImpl.getRequest("getIndexInfo.flattening", "results", intermediateResults, "type", (short)3));
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return true;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return true;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return true;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return true;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        List<String> keys = List.of(COL_TYPE_CAT, COL_TYPE_SCHEM, COL_TYPE_NAME, "CLASS_NAME", COL_DATA_TYPE, COL_REMARKS, "BASE_TYPE");
        return this.emptyResultSet(keys);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        List<String> keys = List.of(COL_TYPE_CAT, COL_TYPE_SCHEM, COL_TYPE_NAME, COL_SUPERTYPE_CAT, COL_SUPERTYPE_SCHEM, COL_SUPERTYPE_NAME);
        return this.emptyResultSet(keys);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        List<String> keys = List.of(COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_SUPERTABLE_NAME);
        return this.emptyResultSet(keys);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        List<String> keys = List.of(COL_TYPE_CAT, COL_TYPE_SCHEM, COL_TYPE_NAME, COL_ATTR_NAME, COL_DATA_TYPE, COL_ATTR_TYPE_NAME, COL_ATTR_SIZE, COL_DECIMAL_DIGITS, COL_NUM_PREC_RADIX, COL_NULLABLE, COL_REMARKS, COL_ATTR_DEF, COL_SQL_DATA_TYPE, COL_SQL_DATETIME_SUB, COL_CHAR_OCTET_LENGTH, COL_ORDINAL_POSITION, COL_IS_NULLABLE, COL_SCOPE_CATALOG, COL_SCOPE_SCHEMA, COL_SCOPE_TABLE, COL_SOURCE_DATA_TYPE);
        return this.emptyResultSet(keys);
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 2;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return Integer.parseInt(this.getDatabaseProductVersion().split("\\.")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        String val;
        int dash = (val = this.getDatabaseProductVersion().split("\\.")[1]).indexOf("-");
        return Integer.parseInt(val.substring(0, dash < 0 ? val.length() : dash));
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 3;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(COL_TABLE_SCHEM);
        keys.add(COL_TABLE_CATALOG);
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.staticPullResponseFor(keys, Collections.singletonList(new Value[]{Values.value(DEFAULT_SCHEMA), Values.value(this.getSingleCatalog())}));
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        String thePattern = Objects.requireNonNullElse(schemaPattern, DEFAULT_SCHEMA).trim().replace("%", ".*");
        if (thePattern.isEmpty() || DEFAULT_SCHEMA.matches("(?i)" + thePattern)) {
            return this.getSchemas();
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(COL_TABLE_SCHEM);
        keys.add(COL_TABLE_CATALOG);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.createEmptyPullResponse();
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return true;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        List<String> keys = List.of("NAME", "MAX_LEN", "DEFAULT_VALUE", "DESCRIPTION");
        ArrayList<Value[]> values = new ArrayList<Value[]>();
        for (ClientInfoProperty property : SUPPORTED_CLIENT_INFO_PROPERTIES) {
            values.add(new Value[]{Values.value(property.name()), Values.value(65536), Values.NULL, Values.value(property.description())});
        }
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.staticPullResponseFor(keys, values);
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    static boolean isSupportedClientInfoProperty(String name) {
        return SUPPORTED_CLIENT_INFO_PROPERTIES.stream().anyMatch(p -> p.name().equals(name));
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        return this.doQueryForResultSet(DatabaseMetadataImpl.getRequest("getFunctions", "name", functionNamePattern, "functionType", 0, "catalogAsParameterWorkaround", this.getSingleCatalog()));
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.assertCatalogIsNullOrEmpty(catalog);
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        List<Map<String, Object>> intermediateResults = this.getArgumentDescriptions("FUNCTIONS", functionNamePattern);
        return this.doQueryForResultSet(DatabaseMetadataImpl.getRequest("getFunctionColumns", "results", intermediateResults, "columnNamePattern", columnNamePattern, "columnType", 1, "nullable", 2, "catalogAsParameterWorkaround", this.getSingleCatalog(), "returnType", 5));
    }

    private List<Map<String, Object>> getArgumentDescriptions(String category, String namePattern) throws SQLException {
        ArrayList<Map<String, Object>> intermediateResults = new ArrayList<Map<String, Object>>();
        Request request = DatabaseMetadataImpl.getRequest("getArgumentDescriptions", "name", namePattern);
        request = new Request(request.query.formatted(category), request.args);
        try (ResultSet rs = this.doQueryForResultSet(request);){
            while (rs.next()) {
                intermediateResults.add(Map.of("name", rs.getString("name"), "description", rs.getString("description"), "argumentDescriptions", rs.getObject("argumentDescription"), "returnDescriptions", rs.getObject("returnDescription")));
            }
        }
        return intermediateResults;
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        DatabaseMetadataImpl.assertSchemaIsPublicOrNull(schemaPattern);
        this.assertCatalogIsNullOrEmpty(catalog);
        List<String> keys = List.of(COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_COLUMN_NAME, COL_DATA_TYPE, COL_COLUMN_SIZE, COL_DECIMAL_DIGITS, COL_NUM_PREC_RADIX, COL_COLUMN_USAGE, COL_REMARKS, COL_CHAR_OCTET_LENGTH, COL_IS_NULLABLE);
        return this.emptyResultSet(keys);
    }

    private ResultSet emptyResultSet(List<String> keys) throws SQLException {
        Neo4jTransaction.RunResponse runResponse = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
        Neo4jTransaction.PullResponse pullResponse = DatabaseMetadataImpl.staticPullResponseFor(keys, List.of());
        return new LocalStatementImpl(this.connection, runResponse, pullResponse).getResultSet();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new Neo4jException(Neo4jException.withReason("This object does not implement the given interface"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    private static Neo4jTransaction.RunResponse createRunResponseForStaticKeys(final List<String> keys) {
        return new Neo4jTransaction.RunResponse(){

            @Override
            public long queryId() {
                return 0L;
            }

            @Override
            public List<String> keys() {
                return keys;
            }
        };
    }

    private static Neo4jTransaction.PullResponse createEmptyPullResponse() {
        return new Neo4jTransaction.PullResponse(){

            @Override
            public List<Record> records() {
                return Collections.emptyList();
            }

            @Override
            public Optional<Neo4jTransaction.ResultSummary> resultSummary() {
                return Optional.empty();
            }

            @Override
            public boolean hasMore() {
                return false;
            }
        };
    }

    private static void assertSchemaIsPublicOrNull(String schemaPattern) throws SQLException {
        if (schemaPattern != null && !DEFAULT_SCHEMA.equalsIgnoreCase(schemaPattern)) {
            throw new Neo4jException(Neo4jException.withReason("Schema must be public or null (was '%s')".formatted(schemaPattern)));
        }
    }

    private void assertCatalogIsNullOrEmpty(String catalog) throws SQLException {
        if (catalog != null && !catalog.isBlank() && !catalog.trim().equalsIgnoreCase(this.getSingleCatalog())) {
            throw new Neo4jException(Neo4jException.withReason("Catalog '%s' is not available in this Neo4j instance, please leave blank or specify the current database name".formatted(catalog)));
        }
    }

    private String getSingleCatalog() throws SQLException {
        return this.connection.unwrap(Neo4jConnection.class).getDatabaseName();
    }

    private Neo4jTransaction.PullResponse doQueryForPullResponse(Request request) throws SQLException {
        QueryAndRunResponse response = this.doQuery(request);
        return response.pullResponse;
    }

    private ResultSet doQueryForResultSet(Request request) throws SQLException {
        QueryAndRunResponse response = this.doQuery(request);
        return new LocalStatementImpl(this.connection, response.runFuture.join(), response.pullResponse).getResultSet();
    }

    private QueryAndRunResponse doQuery(Request request) throws SQLException {
        Neo4jTransaction transaction = this.connection.unwrap(ConnectionImpl.class).newMetadataTransaction(Map.of());
        Neo4jTransaction.RunAndPullResponses responses = transaction.runAndPull(request.query, request.args, -1, 0);
        transaction.commit();
        return new QueryAndRunResponse(responses.pullResponse(), CompletableFuture.completedFuture(responses.runResponse()));
    }

    @Override
    public DatabaseMetaData flush() {
        this.tablesCache.clear();
        return this;
    }

    static {
        try {
            QUERIES.load(Objects.requireNonNull(DatabaseMetadataImpl.class.getResourceAsStream("/queries/DatabaseMetadata.properties")));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        NUMERIC_FUNCTIONS = List.of("abs", "ceil", "floor", "isNaN", "rand", "round", "sign", "e", "exp", "log", "log10", "sqrt", "acos", "asin", "atan", "atan2", "cos", "cot", "degrees", "haversin", "pi", "radians", "sin", "tan");
        STRING_FUNCTIONS = List.of("left", "ltrim", "replace", "reverse", "right", "rtrim", "split", "substring", "toLower", "toString", "toStringOrNull", "toUpper", "trim");
        TIME_DATE_FUNCTIONS = List.of("date", "datetime", "localdatetime", "localtime", "time", "duration");
        SUPPORTED_CLIENT_INFO_PROPERTIES = List.of(new ClientInfoProperty("ApplicationName", "The name of the application currently utilizing the connection"), new ClientInfoProperty("ClientUser", "The name of the user that the application using the connection is performing work for"), new ClientInfoProperty("ClientHostname", "The hostname of the computer the application using the connection is running on"));
        LOGGER = Logger.getLogger(DatabaseMetadataImpl.class.getCanonicalName());
    }

    private record Request(String query, Map<String, Object> args) {
    }

    private record GetTablesCacheKey(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        @Override
        public boolean equals(Object o) {
            if (!(o instanceof GetTablesCacheKey)) {
                return false;
            }
            GetTablesCacheKey that = (GetTablesCacheKey)o;
            return Objects.equals(this.catalog, that.catalog) && Objects.deepEquals(this.types, that.types) && Objects.equals(this.schemaPattern, that.schemaPattern) && Objects.equals(this.tableNamePattern, that.tableNamePattern);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.catalog, this.schemaPattern, this.tableNamePattern, Arrays.hashCode(this.types));
        }
    }

    private record GetTablesCacheValue(Neo4jTransaction.RunResponse runResponse, Neo4jTransaction.PullResponse pullResponse) {
        static GetTablesCacheValue of(ResultSet resultSet) throws SQLException {
            ArrayList<String> keys = new ArrayList<String>();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                keys.add(metaData.getColumnName(i));
            }
            ArrayList<Value[]> values = new ArrayList<Value[]>();
            while (resultSet.next()) {
                Value[] row = new Value[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    row[i - 1] = resultSet.getObject(i, Value.class);
                }
                values.add(row);
            }
            Neo4jTransaction.RunResponse response = DatabaseMetadataImpl.createRunResponseForStaticKeys(keys);
            Neo4jTransaction.PullResponse pull = DatabaseMetadataImpl.staticPullResponseFor(keys, values);
            return new GetTablesCacheValue(response, pull);
        }
    }

    private record UniqueConstraint(String name, List<String> labelsOrTypes, List<String> properties) {
    }

    private record ClientInfoProperty(String name, String description) {
    }

    private record QueryAndRunResponse(Neo4jTransaction.PullResponse pullResponse, CompletableFuture<Neo4jTransaction.RunResponse> runFuture) {
    }
}

