/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.neo4j.jdbc.Neo4jDriver;

final class ProductVersion {
    private static volatile String value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getValue() {
        String computedVersion = value;
        if (computedVersion != null) return computedVersion;
        Class<ProductVersion> clazz = ProductVersion.class;
        synchronized (ProductVersion.class) {
            computedVersion = value;
            if (computedVersion != null) return computedVersion;
            value = ProductVersion.getVersionImpl();
            return value;
        }
    }

    static int getMajorVersion() {
        return ProductVersion.getVersion(0);
    }

    static int getMinorVersion() {
        return ProductVersion.getVersion(1);
    }

    private static int getVersion(int idx) {
        String part;
        String value = ProductVersion.getValue();
        if ("dev".equalsIgnoreCase(value)) {
            throw new IllegalArgumentException("Unsupported or unknown version '%s'".formatted(value));
        }
        int indexOfDash = (part = value.split("\\.")[idx]).indexOf("-");
        return Integer.parseInt(part.substring(0, indexOfDash < 0 ? part.length() : indexOfDash));
    }

    private static String getVersionImpl() {
        try {
            Enumeration<URL> resources = Neo4jDriver.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                if (!ProductVersion.isApplicableManifest(manifest)) continue;
                Attributes attr = manifest.getMainAttributes();
                return ProductVersion.get(attr, "Implementation-Version").toString();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Unable to read from neo4j-jdbc manifest.", ex);
        }
        return "dev";
    }

    private static boolean isApplicableManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        String artifactId = (String)ProductVersion.get(attributes, "Artifact-Id");
        return artifactId != null && Set.of("neo4j-jdbc", "neo4j-jdbc-bundle", "neo4j-jdbc-full-bundle").contains(artifactId);
    }

    private static Object get(Attributes attributes, String key) {
        return attributes.get(new Attributes.Name(key));
    }

    private ProductVersion() {
    }
}

