/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;

final class LoggingProviderImpl
implements LoggingProvider {
    private static final String PREFIX = "org.neo4j.jdbc.network";

    LoggingProviderImpl() {
    }

    @Override
    public System.Logger getLog(Class<?> cls) {
        return new JULBridge(LoggingProviderImpl.getLogger(cls.getSimpleName()));
    }

    @Override
    public System.Logger getLog(String name) {
        return new JULBridge(LoggingProviderImpl.getLogger(name));
    }

    private static Logger getLogger(String name) {
        return Logger.getLogger("%s.%s".formatted(PREFIX, name));
    }

    static final class JULBridge
    implements System.Logger {
        private final Logger logger;

        JULBridge(Logger logger) {
            this.logger = Objects.requireNonNull(logger);
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return this.logger.isLoggable(JULBridge.map(level));
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            this.log0(level, bundle, msg, thrown, new Object[0]);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            this.log0(level, bundle, format, null, params);
        }

        private void log0(System.Logger.Level level, ResourceBundle bundle, String format, Throwable thrown, Object ... params) {
            this.logger.log(JULBridge.map(level), thrown, () -> {
                String formatOrMsg = JULBridge.getString(bundle, format);
                return MessageFormat.format(formatOrMsg, params).formatted(params);
            });
        }

        private static String getString(ResourceBundle bundle, String key) {
            if (bundle == null || key == null) {
                return key;
            }
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException ex) {
                return key;
            }
        }

        private static Level map(System.Logger.Level level) {
            return switch (level) {
                default -> throw new IncompatibleClassChangeError();
                case System.Logger.Level.ALL -> Level.ALL;
                case System.Logger.Level.TRACE -> Level.FINER;
                case System.Logger.Level.DEBUG -> Level.FINE;
                case System.Logger.Level.INFO -> Level.INFO;
                case System.Logger.Level.WARNING -> Level.WARNING;
                case System.Logger.Level.ERROR -> Level.SEVERE;
                case System.Logger.Level.OFF -> Level.OFF;
            };
        }
    }
}

