/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public record NotificationSeverity(Type type, int level) implements Comparable<NotificationSeverity>
{
    public static final NotificationSeverity OFF = new NotificationSeverity(Type.OFF, Integer.MAX_VALUE);
    public static final NotificationSeverity INFORMATION = new NotificationSeverity(Type.INFORMATION, 800);
    public static final NotificationSeverity WARNING = new NotificationSeverity(Type.WARNING, 900);

    public NotificationSeverity {
        Objects.requireNonNull(type, "type must not be null");
    }

    @Override
    public int compareTo(NotificationSeverity severity) {
        return Integer.compare(this.level, severity.level());
    }

    public static Optional<NotificationSeverity> valueOf(String value) {
        return Arrays.stream(Type.values()).filter(type -> type.toString().equals(value)).findFirst().map(type -> switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> INFORMATION;
            case 1 -> WARNING;
            case 2 -> OFF;
        });
    }

    public static enum Type {
        INFORMATION,
        WARNING,
        OFF;

    }
}

