/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.EventLoopThread;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.NettyTransport;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.MultiThreadIoEventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.local.LocalEventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.uring.IoUringIoHandler;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.util.concurrent.FastThreadLocalThread;

public final class EventLoopGroupFactory {
    private static final String THREAD_NAME_PREFIX = "Neo4jDriverIO";
    private static final int THREAD_PRIORITY = 10;
    private static final boolean THREAD_IS_DAEMON = true;
    private final String threadNamePrefix;
    private final NettyTransport nettyTransport;

    public EventLoopGroupFactory(String threadNamePrefix, NettyTransport nettyTransport) {
        this.threadNamePrefix = Objects.requireNonNullElse(threadNamePrefix, THREAD_NAME_PREFIX);
        this.nettyTransport = Objects.requireNonNull(nettyTransport);
    }

    public Class<? extends Channel> channelClass() {
        return this.nettyTransport.channelClass();
    }

    public boolean fastOpenAvailable() {
        return this.nettyTransport.fastOpenAvailable();
    }

    public EventLoopGroup newEventLoopGroup(int threadCount) {
        return switch (this.nettyTransport.type()) {
            default -> throw new IncompatibleClassChangeError();
            case NettyTransport.Type.NIO -> new DriverEventLoopGroup(threadCount);
            case NettyTransport.Type.EPOLL -> new EpollEventLoopGroup(threadCount, (ThreadFactory)new DriverThreadFactory(this.threadNamePrefix));
            case NettyTransport.Type.IO_URING -> new MultiThreadIoEventLoopGroup(threadCount, (ThreadFactory)new DriverThreadFactory(this.threadNamePrefix), IoUringIoHandler.newFactory());
            case NettyTransport.Type.KQUEUE -> new KQueueEventLoopGroup(threadCount, (ThreadFactory)new DriverThreadFactory(this.threadNamePrefix));
            case NettyTransport.Type.LOCAL -> new LocalEventLoopGroup(threadCount, new DriverThreadFactory(this.threadNamePrefix));
        };
    }

    public static void assertNotInEventLoopThread() throws IllegalStateException {
        if (EventLoopGroupFactory.isEventLoopThread(Thread.currentThread())) {
            throw new IllegalStateException("Blocking operation can't be executed in IO thread because it might result in a deadlock. Please do not use blocking API when chaining futures returned by async API methods.");
        }
    }

    public static boolean isEventLoopThread(Thread thread) {
        return thread instanceof EventLoopThread;
    }

    private class DriverEventLoopGroup
    extends NioEventLoopGroup {
        DriverEventLoopGroup(int nThreads) {
            super(nThreads);
        }

        @Override
        protected ThreadFactory newDefaultThreadFactory() {
            return new DriverThreadFactory(EventLoopGroupFactory.this.threadNamePrefix);
        }
    }

    private static class DriverThreadFactory
    extends DefaultThreadFactory {
        DriverThreadFactory(String threadNamePrefix) {
            super(threadNamePrefix, true, 10);
        }

        @Override
        protected Thread newThread(Runnable r, String name) {
            return new DriverThread(this.threadGroup, r, name);
        }
    }

    private static class DriverThread
    extends FastThreadLocalThread
    implements EventLoopThread {
        DriverThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }
    }
}

