/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelPipelineBuilderImpl;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.HandshakeHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.SslHandshakeDurationHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.InboundMessageDispatcher;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.jdbc.internal.shaded.io.netty.handler.ssl.SslHandler;

public class NettyChannelInitializer
extends ChannelInitializer<Channel> {
    private final BoltServerAddress address;
    private final SecurityPlan securityPlan;
    private final long sslHandshakeTimeoutMillis;
    private final Clock clock;
    private final LoggingProvider logging;
    private final CompletableFuture<Duration> sslHandshakeFuture;
    private final CompletableFuture<Channel> handshakeCompleted;
    private final BoltProtocolVersion maxVersion;
    private final ValueFactory valueFactory;

    public NettyChannelInitializer(BoltServerAddress address, SecurityPlan securityPlan, long sslHandshakeTimeoutMillis, Clock clock, LoggingProvider logging, CompletableFuture<Duration> sslHandshakeFuture, CompletableFuture<Channel> handshakeCompleted, BoltProtocolVersion maxVersion, ValueFactory valueFactory) {
        this.address = address;
        this.securityPlan = securityPlan;
        this.sslHandshakeTimeoutMillis = sslHandshakeTimeoutMillis;
        this.clock = clock;
        this.logging = logging;
        this.sslHandshakeFuture = Objects.requireNonNull(sslHandshakeFuture);
        this.handshakeCompleted = Objects.requireNonNull(handshakeCompleted);
        this.maxVersion = maxVersion;
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    protected void initChannel(Channel channel) {
        if (this.securityPlan != null) {
            SslHandler sslHandler = this.createSslHandler();
            SslHandshakeDurationHandler sslHandshakeDurationHandler = new SslHandshakeDurationHandler(channel, this.sslHandshakeFuture);
            channel.pipeline().addFirst(sslHandler, sslHandshakeDurationHandler);
        } else {
            this.sslHandshakeFuture.complete(Duration.ZERO);
            boolean fastOpen = Boolean.TRUE.equals(channel.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT));
            if (fastOpen) {
                HandshakeHandler handshakeHandler = new HandshakeHandler(new ChannelPipelineBuilderImpl(), this.handshakeCompleted, this.address, this.maxVersion, true, this.sslHandshakeTimeoutMillis, this.logging, this.valueFactory);
                channel.pipeline().addFirst(handshakeHandler);
            }
        }
        this.updateChannelAttributes(channel);
    }

    private SslHandler createSslHandler() {
        SSLEngine sslEngine = this.createSslEngine();
        SslHandler sslHandler = new SslHandler(sslEngine);
        if (this.sslHandshakeTimeoutMillis >= 0L) {
            sslHandler.setHandshakeTimeoutMillis(this.sslHandshakeTimeoutMillis);
        }
        return sslHandler;
    }

    private SSLEngine createSslEngine() {
        SSLContext sslContext = this.securityPlan.sslContext();
        String host = this.securityPlan.expectedHostname();
        if (host == null) {
            host = this.address.host();
        }
        SSLEngine sslEngine = sslContext.createSSLEngine(host, this.address.port());
        sslEngine.setUseClientMode(true);
        if (this.securityPlan.verifyHostname()) {
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        }
        return sslEngine;
    }

    private void updateChannelAttributes(Channel channel) {
        ChannelAttributes.setServerAddress(channel, this.address);
        ChannelAttributes.setCreationTimestamp(channel, this.clock.millis());
        ChannelAttributes.setMessageDispatcher(channel, new InboundMessageDispatcher(channel, this.logging));
    }
}

