/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.jdbc.internal.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;

final class SslHandshakeDurationHandler
extends ChannelInboundHandlerAdapter {
    private final CompletableFuture<Duration> sslHandshakeFuture;
    private Instant startInstant;

    SslHandshakeDurationHandler(Channel channel, CompletableFuture<Duration> sslHandshakeFuture) {
        this.sslHandshakeFuture = sslHandshakeFuture;
        boolean fastOpen = Boolean.TRUE.equals(channel.config().getOption(ChannelOption.TCP_FASTOPEN_CONNECT));
        if (fastOpen) {
            this.startInstant = Instant.now();
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        if (this.startInstant == null) {
            this.startInstant = Instant.now();
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (event.isSuccess()) {
                Duration duration = Duration.between(this.startInstant, Instant.now());
                this.sslHandshakeFuture.complete(duration);
            } else {
                this.sslHandshakeFuture.completeExceptionally(event.cause());
            }
            ctx.pipeline().remove(this);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (!this.sslHandshakeFuture.isDone()) {
            this.sslHandshakeFuture.completeExceptionally(new IOException("Inactive channel before SSL handshake is finished"));
        }
        super.channelInactive(ctx);
    }
}

