/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.Message;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageEncoder;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageFormat;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.ValuePacker;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

public abstract class AbstractMessageWriter
implements MessageFormat.Writer {
    private final ValuePacker packer;
    private final Map<Byte, MessageEncoder> encodersByMessageSignature;
    private final ValueFactory valueFactory;

    protected AbstractMessageWriter(ValuePacker packer, Map<Byte, MessageEncoder> encodersByMessageSignature, ValueFactory valueFactory) {
        this.packer = Objects.requireNonNull(packer);
        this.encodersByMessageSignature = Objects.requireNonNull(encodersByMessageSignature);
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public final void write(Message msg) throws IOException {
        byte signature = msg.signature();
        MessageEncoder encoder = this.encodersByMessageSignature.get(signature);
        if (encoder == null) {
            throw new IOException("No encoder found for message " + String.valueOf(msg) + " with signature " + signature);
        }
        encoder.encode(msg, this.packer, this.valueFactory);
    }
}

