/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging;

import java.time.Clock;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.BoltAgent;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseName;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltUnsupportedFeatureException;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.RoutingContext;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.BoltProtocolUtil;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageFormat;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.PullMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.Connection;
import org.neo4j.jdbc.internal.shaded.bolt.observation.BoltExchangeObservation;
import org.neo4j.jdbc.internal.shaded.bolt.summary.BeginSummary;
import org.neo4j.jdbc.internal.shaded.bolt.summary.DiscardSummary;
import org.neo4j.jdbc.internal.shaded.bolt.summary.RouteSummary;
import org.neo4j.jdbc.internal.shaded.bolt.summary.RunSummary;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;

public interface BoltProtocol {
    public MessageFormat createMessageFormat();

    public CompletionStage<Channel> initializeChannel(Channel var1, String var2, BoltAgent var3, Map<String, Value> var4, RoutingContext var5, NotificationConfig var6, Clock var7, CompletableFuture<Long> var8, ValueFactory var9, BoltExchangeObservation var10);

    public CompletionStage<Void> route(Connection var1, Map<String, Value> var2, Set<String> var3, String var4, String var5, MessageHandler<RouteSummary> var6, Clock var7, LoggingProvider var8, ValueFactory var9, BoltExchangeObservation var10);

    public CompletionStage<Void> beginTransaction(Connection var1, DatabaseName var2, AccessMode var3, String var4, Set<String> var5, Duration var6, Map<String, Value> var7, String var8, NotificationConfig var9, MessageHandler<BeginSummary> var10, LoggingProvider var11, ValueFactory var12, BoltExchangeObservation var13);

    public CompletionStage<Void> commitTransaction(Connection var1, MessageHandler<String> var2, BoltExchangeObservation var3);

    public CompletionStage<Void> rollbackTransaction(Connection var1, MessageHandler<Void> var2, BoltExchangeObservation var3);

    public CompletionStage<Void> telemetry(Connection var1, Integer var2, MessageHandler<Void> var3, BoltExchangeObservation var4);

    public CompletionStage<Void> runAuto(Connection var1, DatabaseName var2, AccessMode var3, String var4, String var5, Map<String, Value> var6, Set<String> var7, Duration var8, Map<String, Value> var9, NotificationConfig var10, MessageHandler<RunSummary> var11, LoggingProvider var12, ValueFactory var13, BoltExchangeObservation var14);

    public CompletionStage<Void> run(Connection var1, String var2, Map<String, Value> var3, MessageHandler<RunSummary> var4, BoltExchangeObservation var5);

    public CompletionStage<Void> pull(Connection var1, long var2, long var4, PullMessageHandler var6, ValueFactory var7, BoltExchangeObservation var8);

    public CompletionStage<Void> discard(Connection var1, long var2, long var4, MessageHandler<DiscardSummary> var6, ValueFactory var7, BoltExchangeObservation var8);

    public CompletionStage<Void> reset(Connection var1, MessageHandler<Void> var2, BoltExchangeObservation var3);

    default public CompletionStage<Void> logoff(Connection connection, MessageHandler<Void> handler, BoltExchangeObservation observation) {
        return CompletableFuture.failedStage(new BoltUnsupportedFeatureException("logoff not supported"));
    }

    default public CompletionStage<Void> logon(Connection connection, Map<String, Value> authMap, Clock clock, MessageHandler<Void> handler, ValueFactory valueFactory, BoltExchangeObservation observation) {
        return CompletableFuture.failedStage(new BoltUnsupportedFeatureException("logon not supported"));
    }

    public BoltProtocolVersion version();

    public static BoltProtocol forChannel(Channel channel) {
        return BoltProtocol.forVersion(ChannelAttributes.protocolVersion(channel));
    }

    public static BoltProtocol forVersion(BoltProtocolVersion version) {
        BoltProtocol protocol = (BoltProtocol)BoltProtocolUtil.versionToProtocol.get(version);
        if (protocol != null) {
            return protocol;
        }
        throw new BoltClientException("Unknown protocol version: " + String.valueOf(version));
    }
}

