/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.common;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.bolt.GqlError;
import org.neo4j.jdbc.internal.shaded.bolt.GqlStatusError;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageFormat;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.ResponseMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.ValueUnpacker;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.common.CommonValueUnpacker;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.packstream.PackInput;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

public class CommonMessageReader
implements MessageFormat.Reader {
    protected final ValueUnpacker unpacker;
    protected final ValueFactory valueFactory;

    public CommonMessageReader(PackInput input, boolean dateTimeUtcEnabled, ValueFactory valueFactory) {
        this(new CommonValueUnpacker(input, dateTimeUtcEnabled, valueFactory), valueFactory);
    }

    protected CommonMessageReader(ValueUnpacker unpacker, ValueFactory valueFactory) {
        this.unpacker = unpacker;
        this.valueFactory = Objects.requireNonNull(valueFactory);
    }

    @Override
    public void read(ResponseMessageHandler handler) throws IOException {
        this.unpacker.unpackStructHeader();
        int type = this.unpacker.unpackStructSignature();
        switch (type) {
            case 112: {
                this.unpackSuccessMessage(handler);
                break;
            }
            case 127: {
                this.unpackFailureMessage(handler);
                break;
            }
            case 126: {
                this.unpackIgnoredMessage(handler);
                break;
            }
            case 113: {
                this.unpackRecordMessage(handler);
                break;
            }
            default: {
                throw new IOException("Unknown message type: " + type);
            }
        }
    }

    private void unpackSuccessMessage(ResponseMessageHandler output) throws IOException {
        Map<String, Value> map = this.unpacker.unpackMap();
        output.handleSuccessMessage(map);
    }

    protected void unpackFailureMessage(ResponseMessageHandler output) throws IOException {
        Map<String, Value> params = this.unpacker.unpackMap();
        String code = params.get("code").asString();
        String message = params.get("message").asString();
        Map<String, Value> diagnosticRecord = Map.ofEntries(Map.entry("CURRENT_SCHEMA", this.valueFactory.value("/")), Map.entry("OPERATION", this.valueFactory.value("")), Map.entry("OPERATION_CODE", this.valueFactory.value("0")));
        GqlError gqlError = new GqlError(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), code, message, diagnosticRecord, null);
        output.handleFailureMessage(gqlError);
    }

    private void unpackIgnoredMessage(ResponseMessageHandler output) {
        output.handleIgnoredMessage();
    }

    private void unpackRecordMessage(ResponseMessageHandler output) throws IOException {
        List<Value> fields = this.unpacker.unpackList();
        output.handleRecordMessage(fields);
    }
}

