/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v54;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers.TelemetryResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.BoltProtocol;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageFormat;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.TelemetryMessage;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v53.BoltProtocolV53;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v54.MessageFormatV54;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.Connection;
import org.neo4j.jdbc.internal.shaded.bolt.observation.BoltExchangeObservation;

public class BoltProtocolV54
extends BoltProtocolV53 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(5, 4);
    public static final BoltProtocol INSTANCE = new BoltProtocolV54();

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }

    @Override
    public CompletionStage<Void> telemetry(Connection connection, Integer api, MessageHandler<Void> handler, BoltExchangeObservation observation) {
        TelemetryMessage telemetry = new TelemetryMessage(api);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                handler.onError((Throwable)throwable);
            } else {
                observation.onSummary(telemetry.name());
                handler.onSummary(null);
            }
        });
        return connection.write(telemetry, new TelemetryResponseHandler(future)).thenAccept(ignored -> observation.onWrite(telemetry.name()));
    }

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV54();
    }
}

