/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.TransactionInfo;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSON;

public record HttpContext(HttpClient httpClient, URI baseUri, JSON json, String defaultDatabase, String userAgent) {
    private static final String DEFAULT_DATABASE_KEY_NAME = "defaultDatabase";
    private static final String QUERY_URL_FORMAT = "%s/db/%s/query/v2";
    public static final String QUERY_URL_TEMPLATE = "%s/db/%s/query/v2".formatted("", "{databaseName}");
    private static final String TRANSACTION_BASE_URL_FORMAT = "%s/tx".formatted("%s/db/%s/query/v2");
    public static final String TRANSACTION_BASE_URL_TEMPLATE = TRANSACTION_BASE_URL_FORMAT.formatted("", "{databaseName}");
    private static final String TRANSACTION_QUERY_URL_FORMAT = "%s/%s".formatted(TRANSACTION_BASE_URL_FORMAT, "%s");
    public static final String TRANSACTION_QUERY_URL_TEMPLATE = TRANSACTION_QUERY_URL_FORMAT.formatted("", "{databaseName}", "{transactionId}");
    private static final String TRANSACTION_COMMIT_URL_FORMAT = "%s/commit".formatted(TRANSACTION_QUERY_URL_FORMAT);
    public static final String TRANSACTION_COMMIT_URL_TEMPLATE = TRANSACTION_QUERY_URL_FORMAT.formatted("", "{databaseName}", "{transactionId}");

    public HttpContext {
        String query;
        String path = baseUri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((query = baseUri.getQuery()) != null) {
            for (String pair : query.split("&")) {
                String value;
                String key;
                String[] keyAndValue = pair.split("=");
                if (keyAndValue.length != 2 || !DEFAULT_DATABASE_KEY_NAME.equals(key = keyAndValue[0]) || (value = keyAndValue[1].trim()).isEmpty()) continue;
                defaultDatabase = value;
            }
        }
        try {
            baseUri = new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new BoltClientException("Invalid URI", e);
        }
    }

    public HttpContext(HttpClient httpClient, URI baseUri, JSON json, String userAgent) {
        this(httpClient, baseUri, json, null, userAgent);
    }

    public String[] headers(String authHeader) {
        return HttpContext.headers(authHeader, this.userAgent);
    }

    private static String[] headers(String authHeader, String userAgent) {
        String[] headers = new String[userAgent != null ? 8 : 6];
        headers[0] = "Content-Type";
        headers[1] = "application/vnd.neo4j.query";
        headers[2] = "Accept";
        headers[3] = "application/vnd.neo4j.query";
        headers[4] = "Authorization";
        headers[5] = Objects.requireNonNull(authHeader);
        if (userAgent != null) {
            headers[6] = "User-Agent";
            headers[7] = userAgent;
        }
        return headers;
    }

    URI queryUrl(String databaseName) {
        return URI.create(QUERY_URL_FORMAT.formatted(this.baseUri, databaseName)).normalize();
    }

    URI txUrl(String databaseName) {
        return URI.create(TRANSACTION_BASE_URL_FORMAT.formatted(this.baseUri, databaseName)).normalize();
    }

    URI txUrl(TransactionInfo tx) {
        return URI.create(TRANSACTION_QUERY_URL_FORMAT.formatted(this.baseUri, tx.databaseName(), tx.id())).normalize();
    }

    URI commitUrl(TransactionInfo tx) {
        return URI.create(TRANSACTION_COMMIT_URL_FORMAT.formatted(this.baseUri, tx.databaseName(), tx.id())).normalize();
    }
}

