/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;

final class HttpUtil {
    static String mapToString(HttpRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP Request:\n");
        sb.append("  Method: ").append(request.method()).append("\n");
        sb.append("  URI: ").append(request.uri()).append("\n");
        sb.append("  Headers:\n");
        request.headers().map().forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(String.join((CharSequence)", ", v)).append("\n"));
        if (request.bodyPublisher().isPresent()) {
            sb.append("  Body: [BodyPublisher present, raw body not printable]\n");
        } else {
            sb.append("  Body: <none>\n");
        }
        return sb.toString();
    }

    static <T> String mapToString(HttpResponse<T> response) {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP Response:\n");
        sb.append("  Status Code: ").append(response.statusCode()).append("\n");
        sb.append("  Headers:\n");
        for (Map.Entry<String, List<String>> entry : response.headers().map().entrySet()) {
            sb.append("    ").append(entry.getKey()).append(": ").append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue())).append("\n");
        }
        T body = response.body();
        if (body != null) {
            sb.append("  Body:\n");
            sb.append("    ").append(body.toString().replace("\n", "\n    ")).append("\n");
        } else {
            sb.append("  Body: <null>\n");
        }
        return sb.toString();
    }

    private HttpUtil() {
    }
}

