/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.neo4j.jdbc.internal.shaded.cypherdsl.Comparison;
import org.neo4j.jdbc.internal.shaded.cypherdsl.CompoundCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ConstantCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.HasLabelCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Predicates;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipPattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.RelationshipPatternCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

final class Conditions {
    private Conditions() {
    }

    static Condition includesAll(Expression lhs, Expression rhs) {
        SymbolicName x = SymbolicName.of("x");
        return Predicates.all(x).in(rhs).where(x.in(lhs));
    }

    static Condition includesAny(Expression lhs, Expression rhs) {
        SymbolicName x = SymbolicName.of("x");
        return Predicates.any(x).in(rhs).where(x.in(lhs));
    }

    static Condition matching(RelationshipPattern relationshipPattern) {
        return RelationshipPatternCondition.of(relationshipPattern);
    }

    static Condition matches(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.MATCHES, rhs);
    }

    static Condition isEqualTo(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.EQUALITY, rhs);
    }

    static Condition isNotEqualTo(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.INEQUALITY, rhs);
    }

    static Condition lt(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.LESS_THAN, rhs);
    }

    static Condition lte(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.LESS_THAN_OR_EQUAL_TO, rhs);
    }

    static Condition gte(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.GREATER_THAN_OR_EQUAL_TO, rhs);
    }

    static Condition gt(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.GREATER_THAN, rhs);
    }

    static Condition not(Condition condition) {
        Assertions.notNull(condition, "Condition to negate must not be null.");
        return condition.not();
    }

    static Condition not(RelationshipPattern pattern) {
        return RelationshipPatternCondition.not(pattern);
    }

    static Condition startsWith(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.STARTS_WITH, rhs);
    }

    static Condition contains(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.CONTAINS, rhs);
    }

    static Condition endsWith(Expression lhs, Expression rhs) {
        return Comparison.create(lhs, Operator.ENDS_WITH, rhs);
    }

    static Condition noCondition() {
        return CompoundCondition.empty();
    }

    static Condition isNull(Expression expression) {
        return Comparison.create(Operator.IS_NULL, expression);
    }

    static Condition isNotNull(Expression expression) {
        return Comparison.create(Operator.IS_NOT_NULL, expression);
    }

    static Condition isTrue() {
        return ConstantCondition.TRUE;
    }

    static Condition isFalse() {
        return ConstantCondition.FALSE;
    }

    static Condition hasLabelsOrType(SymbolicName symbolicName, String ... labelsOrTypes) {
        return HasLabelCondition.create(symbolicName, labelsOrTypes);
    }
}

