/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.Arrays;
import java.util.List;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AliasedExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.CollectExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.CountExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Named;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Pattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SubqueryExpressionBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.With;

final class Expressions {
    private Expressions() {
    }

    static CountExpression count(PatternElement requiredPattern, PatternElement ... patternElement) {
        return CountExpression.count(Pattern.of(requiredPattern, patternElement));
    }

    static CountExpression count(Statement.UnionQuery union) {
        return CountExpression.count(union);
    }

    static CountExpression count(Statement statement, IdentifiableElement ... imports) {
        return CountExpression.count(statement, imports);
    }

    static CountExpression count(List<PatternElement> pattern, Where where) {
        return CountExpression.count(pattern, where);
    }

    static SubqueryExpressionBuilder with(IdentifiableElement ... identifiableElements) {
        ExpressionList returnItems = new ExpressionList(Arrays.stream(identifiableElements).map(IdentifiableElement::asExpression).toList());
        final With with = new With(false, returnItems, null, null, null, null);
        return new SubqueryExpressionBuilder(){

            @Override
            public CountExpression count(PatternElement requiredPattern, PatternElement ... patternElement) {
                return CountExpression.count(with, Pattern.of(requiredPattern, patternElement));
            }

            @Override
            public CountExpression count(Statement.UnionQuery union) {
                return CountExpression.count(with, union);
            }

            @Override
            public CollectExpression collect(Statement statement) {
                return CollectExpression.collect(with, statement);
            }
        };
    }

    static Expression collect(Statement statement) {
        if (!statement.doesReturnOrYield()) {
            throw new IllegalArgumentException("The final RETURN clause in a subquery used with COLLECT is mandatory and the RETURN clause must return exactly one column.");
        }
        return CollectExpression.collect(statement);
    }

    static <T extends Expression> Expression nameOrExpression(T expression) {
        if (expression instanceof Named) {
            Named named = (Named)((Object)expression);
            return named.getSymbolicName().map(Expression.class::cast).orElse(expression);
        }
        return expression;
    }

    static SymbolicName[] createSymbolicNames(String[] variables) {
        return (SymbolicName[])Arrays.stream(variables).map(SymbolicName::of).toArray(SymbolicName[]::new);
    }

    static SymbolicName[] createSymbolicNames(Named[] variables) {
        return (SymbolicName[])Arrays.stream(variables).map(Named::getRequiredSymbolicName).toArray(SymbolicName[]::new);
    }

    static String format(Expression expression) {
        if (expression instanceof Named) {
            Named named = (Named)((Object)expression);
            return named.getRequiredSymbolicName().getValue();
        }
        if (expression instanceof AliasedExpression) {
            AliasedExpression aliasedExpression = (AliasedExpression)expression;
            return aliasedExpression.getAlias();
        }
        if (expression instanceof SymbolicName) {
            SymbolicName symbolicName = (SymbolicName)expression;
            return symbolicName.getValue();
        }
        if (expression instanceof Property) {
            StringBuilder ref = new StringBuilder();
            expression.accept(segment -> {
                if (segment instanceof SymbolicName) {
                    SymbolicName symbolicName = (SymbolicName)segment;
                    if (!ref.isEmpty()) {
                        ref.append(".");
                    }
                    ref.append(symbolicName.getValue());
                }
            });
            return ref.toString();
        }
        throw new IllegalArgumentException("Cannot format expression " + expression.toString());
    }
}

