/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.Arrays;
import java.util.Objects;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AliasedExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Literal;
import org.neo4j.jdbc.internal.shaded.cypherdsl.With;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.INTERNAL, since="2023.1.0")
record ImportingWith(With imports, With renames) implements Visitable
{
    ImportingWith() {
        this(null, null);
    }

    static ImportingWith of(IdentifiableElement ... imports) {
        ExpressionList returnItems = new ExpressionList(Arrays.stream(imports).map(i -> {
            if (i instanceof AliasedExpression) {
                AliasedExpression aliasedExpression = (AliasedExpression)i;
                Expression delegate = aliasedExpression.getDelegate();
                if (delegate instanceof Literal) {
                    return null;
                }
                return delegate;
            }
            return i.asExpression();
        }).filter(Objects::nonNull).toList());
        With optionalImports = returnItems.isEmpty() ? null : new With(false, returnItems, null, null, null, null);
        returnItems = new ExpressionList(Arrays.stream(imports).filter(AliasedExpression.class::isInstance).map(Expression.class::cast).toList());
        With optionalRenames = returnItems.isEmpty() ? null : new With(false, returnItems, null, null, null, null);
        return new ImportingWith(optionalImports, optionalRenames);
    }

    @Override
    public void accept(Visitor visitor) {
        Visitable.visitIfNotNull(this.imports, visitor);
        Visitable.visitIfNotNull(this.renames, visitor);
    }
}

