/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LabelExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeBase;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeLabel;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Properties;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class InternalNodeImpl
extends NodeBase<InternalNodeImpl> {
    InternalNodeImpl() {
    }

    InternalNodeImpl(LabelExpression labelExpression, Where innerPredicate) {
        super(null, null, labelExpression, null, innerPredicate);
    }

    InternalNodeImpl(String primaryLabel, String ... additionalLabels) {
        super(primaryLabel, additionalLabels);
    }

    InternalNodeImpl(SymbolicName symbolicName, List<NodeLabel> labels, LabelExpression labelExpression, Properties properties, Where innerPredicate) {
        super(symbolicName, labels, labelExpression, properties, innerPredicate);
    }

    InternalNodeImpl(SymbolicName symbolicName, String primaryLabel, MapExpression properties, String ... additionalLabels) {
        super(symbolicName, primaryLabel, properties, additionalLabels);
    }

    @Override
    public InternalNodeImpl named(SymbolicName newSymbolicName) {
        Assertions.notNull(newSymbolicName, "Symbolic name is required.");
        return new InternalNodeImpl(newSymbolicName, this.labels, this.labelExpression, this.properties, this.innerPredicate);
    }

    @Override
    public InternalNodeImpl withProperties(MapExpression newProperties) {
        return new InternalNodeImpl((SymbolicName)this.getSymbolicName().orElse(null), this.labels, this.labelExpression, Properties.create(newProperties), this.innerPredicate);
    }

    @Override
    public Node where(Expression predicate) {
        if (predicate == null) {
            return this;
        }
        return new InternalNodeImpl((SymbolicName)this.getSymbolicName().orElse(null), this.labels, this.labelExpression, this.properties, Where.from(predicate));
    }
}

