/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class ListExpression
implements Expression {
    private final ExpressionList content;

    private ListExpression(ExpressionList content) {
        this.content = content;
    }

    static Expression listOrSingleExpression(Expression ... expressions) {
        Assertions.notNull(expressions, "Expressions are required.");
        Assertions.notEmpty(expressions, "At least one expression is required.");
        if (expressions.length == 1) {
            return expressions[0];
        }
        return ListExpression.create(expressions);
    }

    static ListExpression create(Expression ... expressions) {
        return new ListExpression(new ExpressionList(expressions));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.content.accept(visitor);
        visitor.leave(this);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

