/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Limit;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Order;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Skip;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.STABLE, since="1.0")
public final class ReturnBody
implements Visitable {
    private final ExpressionList returnItems;
    private final Order order;
    private final Skip skip;
    private final Limit limit;

    ReturnBody(ExpressionList returnItems, Order order, Skip skip, Limit limit) {
        this.returnItems = returnItems;
        this.order = order;
        this.skip = skip;
        this.limit = limit;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.returnItems.accept(visitor);
        Visitable.visitIfNotNull(this.order, visitor);
        Visitable.visitIfNotNull(this.skip, visitor);
        Visitable.visitIfNotNull(this.limit, visitor);
        visitor.leave(this);
    }

    @API(status=API.Status.INTERNAL)
    List<Expression> getReturnItems() {
        return this.returnItems.getChildren();
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

