/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Asterisk;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Create;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Delete;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.HasLabelCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.KeyValueMapEntry;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LabelExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListOperator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Literal;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LiteralBase;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Match;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Merge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Named;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeLabel;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Parameter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ParameterCollectingVisitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PeriodLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PropertyContainer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PropertyLookup;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RawLiteral;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementCatalog;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementContext;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.With;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.Namespace;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.ReflectiveVisitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.ScopingStrategy;

@RegisterForReflection
class StatementCatalogBuildingVisitor
extends ReflectiveVisitor {
    private static final String TYPE_OF_COMPOUND_CONDITION = "org.neo4j.jdbc.internal.shaded.cypherdsl.CompoundCondition";
    private final AtomicReference<StatementCatalog.Clause> currentClause = new AtomicReference<StatementCatalog.Clause>(StatementCatalog.Clause.UNKNOWN);
    private final Deque<PatternElement> currentPatternElement = new ArrayDeque<PatternElement>();
    private final Set<StatementCatalog.Token> tokens = new LinkedHashSet<StatementCatalog.Token>();
    private final Set<StatementCatalog.Property> properties = new LinkedHashSet<StatementCatalog.Property>();
    private final Set<StatementCatalog.LabelFilter> labelFilters = new LinkedHashSet<StatementCatalog.LabelFilter>();
    private final Map<StatementCatalog.Property, Set<StatementCatalog.PropertyFilter>> propertyFilters = new LinkedHashMap<StatementCatalog.Property, Set<StatementCatalog.PropertyFilter>>();
    private final Deque<Map<SymbolicName, PatternElement>> patternLookup = new ArrayDeque<Map<SymbolicName, PatternElement>>();
    private final Deque<Condition> currentConditions = new ArrayDeque<Condition>();
    private final AtomicReference<Set<StatementCatalog.Token>> currentHasLabelCondition = new AtomicReference();
    private final StatementContext statementContext;
    private final boolean renderConstantsAsParameters;
    private final ScopingStrategy scopingStrategy;
    private final ParameterCollectingVisitor allParameters;
    private final Map<Node, Set<StatementCatalog.Token>> currentUndirectedRelations = new HashMap<Node, Set<StatementCatalog.Token>>();
    private final Map<Node, Set<StatementCatalog.Token>> currentIncomingRelations = new HashMap<Node, Set<StatementCatalog.Token>>();
    private final Map<Node, Set<StatementCatalog.Token>> currentOutgoingRelations = new HashMap<Node, Set<StatementCatalog.Token>>();
    private final Map<StatementCatalog.Token, Relationships> relationships = new HashMap<StatementCatalog.Token, Relationships>();
    private final Set<Literal<?>> literals = new LinkedHashSet();

    StatementCatalogBuildingVisitor(StatementContext statementContext, boolean renderConstantsAsParameters) {
        this.statementContext = statementContext;
        this.renderConstantsAsParameters = renderConstantsAsParameters;
        this.scopingStrategy = ScopingStrategy.create(List.of((cause, imports) -> this.patternLookup.push(this.createNewScope((Collection<IdentifiableElement>)imports))), List.of((cause, exports) -> this.importIntoCurrentScope((Collection<IdentifiableElement>)exports)));
        this.patternLookup.push(new HashMap());
        this.allParameters = new ParameterCollectingVisitor(statementContext, renderConstantsAsParameters);
    }

    private static void copyIdentifiableElements(Collection<IdentifiableElement> elements, Map<SymbolicName, PatternElement> source, Map<SymbolicName, PatternElement> target) {
        for (IdentifiableElement e : elements) {
            SymbolicName s;
            if (e instanceof SymbolicName && source.containsKey(s = (SymbolicName)e)) {
                target.put(s, source.get(s));
                continue;
            }
            if (!(e instanceof Named)) continue;
            Named n = (Named)e;
            if (!(e instanceof PatternElement)) continue;
            PatternElement p = (PatternElement)((Object)e);
            target.put(n.getRequiredSymbolicName(), p);
        }
    }

    private static Set<StatementCatalog.Token> getAllLabels(Node node) {
        TreeSet<StatementCatalog.Token> result = new TreeSet<StatementCatalog.Token>();
        if (node.getLabels().isEmpty()) {
            node.accept(segment -> {
                if (segment instanceof LabelExpression) {
                    LabelExpression l = (LabelExpression)segment;
                    StatementCatalogBuildingVisitor.collectLabels(l, null, result);
                }
            });
        } else {
            node.getLabels().stream().map(NodeLabel::getValue).map(StatementCatalog.Token::label).forEach(result::add);
        }
        return result;
    }

    private static void collectLabels(LabelExpression l, LabelExpression.Type parent, Set<StatementCatalog.Token> labels) {
        if (l == null) {
            return;
        }
        LabelExpression.Type current = l.type();
        StatementCatalogBuildingVisitor.collectLabels(l.lhs(), current, labels);
        if (current == LabelExpression.Type.LEAF) {
            l.value().stream().map(StatementCatalog.Token::label).forEach(labels::add);
        }
        StatementCatalogBuildingVisitor.collectLabels(l.rhs(), current, labels);
    }

    private Map<SymbolicName, PatternElement> createNewScope(Collection<IdentifiableElement> imports) {
        this.addRelationsInCurrentScope();
        Map<SymbolicName, PatternElement> currentScope = this.patternLookup.isEmpty() ? Collections.emptyMap() : this.patternLookup.peek();
        HashMap<SymbolicName, PatternElement> newScope = new HashMap<SymbolicName, PatternElement>();
        StatementCatalogBuildingVisitor.copyIdentifiableElements(imports, currentScope, newScope);
        return newScope;
    }

    private void importIntoCurrentScope(Collection<IdentifiableElement> exports) {
        Map<SymbolicName, PatternElement> previousScope = this.patternLookup.pop();
        HashMap<SymbolicName, PatternElement> currentScope = this.patternLookup.isEmpty() ? new HashMap() : this.patternLookup.peek();
        StatementCatalogBuildingVisitor.copyIdentifiableElements(exports, previousScope, currentScope);
    }

    StatementCatalog getResult() {
        this.addRelationsInCurrentScope();
        ParameterCollectingVisitor.ParameterInformation parameterInformation = this.allParameters.getResult();
        return new DefaultStatementCatalog(this.tokens, this.labelFilters, this.properties, this.propertyFilters, this.scopingStrategy.getIdentifiables(), parameterInformation, this.relationships, this.literals);
    }

    void addRelationsInCurrentScope() {
        this.finish(this.currentOutgoingRelations, Relationships::outgoing);
        this.finish(this.currentIncomingRelations, Relationships::incoming);
        this.finish(this.currentUndirectedRelations, Relationships::undirected);
    }

    private void finish(Map<Node, Set<StatementCatalog.Token>> nodesToRelations, Function<Relationships, Set<StatementCatalog.Token>> targetProvider) {
        nodesToRelations.forEach((k, v) -> {
            Set<StatementCatalog.Token> labels = StatementCatalogBuildingVisitor.getAllLabels((Node)k.getSymbolicName().map(this::lookup).orElse((PatternElement)k));
            labels.forEach(t -> {
                Relationships rels = this.relationships.computeIfAbsent((StatementCatalog.Token)t, unused -> new Relationships());
                ((Set)targetProvider.apply(rels)).addAll(v);
            });
        });
        nodesToRelations.clear();
    }

    @Override
    protected boolean preEnter(Visitable visitable) {
        this.scopingStrategy.doEnter(visitable);
        return true;
    }

    @Override
    protected void postLeave(Visitable visitable) {
        this.scopingStrategy.doLeave(visitable);
    }

    void enter(Match match) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.MATCH);
    }

    void leave(Match match) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.MATCH, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(Create create) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.CREATE);
    }

    void leave(Create create) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.CREATE, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(Merge merge) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.MERGE);
    }

    void leave(Merge merge) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.MERGE, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(Delete delete) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.DELETE);
    }

    void leave(Delete delete) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.DELETE, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(With with) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.UNKNOWN, StatementCatalog.Clause.WITH);
    }

    void leave(With with) {
        this.currentClause.compareAndSet(StatementCatalog.Clause.WITH, StatementCatalog.Clause.UNKNOWN);
    }

    void enter(Node node) {
        node.getSymbolicName().ifPresent(s -> this.store((SymbolicName)s, node));
        this.currentPatternElement.push(node);
    }

    void enter(KeyValueMapEntry mapEntry) {
        StatementCatalog.Property property;
        PatternElement owner = this.currentPatternElement.peek();
        if (owner == null) {
            return;
        }
        if (owner instanceof Node) {
            Node node = (Node)owner;
            property = new StatementCatalog.Property(StatementCatalogBuildingVisitor.getAllLabels(node), mapEntry.getKey());
        } else if (owner instanceof Relationship) {
            Relationship relationship = (Relationship)owner;
            property = new StatementCatalog.Property(relationship.getDetails().getTypes().stream().map(StatementCatalog.Token::type).collect(Collectors.toSet()), mapEntry.getKey());
        } else {
            property = null;
        }
        if (property == null) {
            return;
        }
        this.properties.add(property);
        Expression left = ((PropertyContainer)((Object)owner)).getSymbolicName().isPresent() ? ((PropertyContainer)((Object)owner)).property(mapEntry.getKey()) : PropertyLookup.forName(mapEntry.getKey());
        ParameterCollectingVisitor.ParameterInformation parameterInformation = this.extractParameters(mapEntry.getValue());
        this.propertyFilters.computeIfAbsent(property, ignored -> new HashSet()).add(new StatementCatalog.PropertyFilter(this.currentClause.get(), left, Operator.EQUALITY, mapEntry.getValue(), parameterInformation.names, parameterInformation.values));
    }

    void leave(Node node) {
        this.currentPatternElement.removeFirstOccurrence(node);
    }

    void enter(Relationship relationship) {
        relationship.getSymbolicName().ifPresent(s -> this.store((SymbolicName)s, relationship));
        this.currentPatternElement.push(relationship);
        List<StatementCatalog.Token> types = relationship.getDetails().getTypes().stream().map(StatementCatalog.Token::type).toList();
        this.tokens.addAll(types);
        this.storeRelations(relationship.getLeft(), relationship.getRight(), types, relationship.getDetails().getDirection());
    }

    private void storeRelations(Node left, Node right, List<StatementCatalog.Token> types, Relationship.Direction direction) {
        Function<Node, Set> targetSupplier = unused -> new HashSet();
        switch (direction) {
            case UNI: {
                this.currentUndirectedRelations.computeIfAbsent(left, targetSupplier).addAll(types);
                this.currentUndirectedRelations.computeIfAbsent(right, targetSupplier).addAll(types);
                break;
            }
            case LTR: {
                this.currentOutgoingRelations.computeIfAbsent(left, targetSupplier).addAll(types);
                this.currentIncomingRelations.computeIfAbsent(right, targetSupplier).addAll(types);
                break;
            }
            case RTL: {
                this.currentIncomingRelations.computeIfAbsent(left, targetSupplier).addAll(types);
                this.currentOutgoingRelations.computeIfAbsent(right, targetSupplier).addAll(types);
            }
        }
    }

    void leave(Relationship relationship) {
        this.currentPatternElement.removeFirstOccurrence(relationship);
    }

    void enter(Property property) {
        StatementCatalog.Property newProperty;
        if (property.getNames().size() != 1) {
            return;
        }
        PropertyLookup lookup = property.getNames().get(0);
        if (lookup.isDynamicLookup()) {
            return;
        }
        Expression expression = property.getContainerReference();
        if (!(expression instanceof SymbolicName)) {
            return;
        }
        SymbolicName s = (SymbolicName)expression;
        AtomicReference propertyName = new AtomicReference();
        lookup.accept(segment -> {
            if (segment instanceof SymbolicName) {
                SymbolicName name = (SymbolicName)segment;
                propertyName.compareAndSet(null, name.getValue());
            }
        });
        PatternElement patternElement = this.lookup(s);
        if (patternElement instanceof Node) {
            Node node = (Node)patternElement;
            newProperty = new StatementCatalog.Property(StatementCatalogBuildingVisitor.getAllLabels(node), (String)propertyName.get());
        } else if (patternElement instanceof Relationship) {
            Relationship relationship = (Relationship)patternElement;
            newProperty = new StatementCatalog.Property(relationship.getDetails().getTypes().stream().map(StatementCatalog.Token::type).collect(Collectors.toSet()), (String)propertyName.get());
        } else {
            return;
        }
        this.properties.add(newProperty);
        if (this.inCurrentCondition(property)) {
            this.propertyFilters.computeIfAbsent(newProperty, ignored -> new HashSet()).add(this.extractPropertyCondition(newProperty, this.currentConditions.peek()));
        }
    }

    void enter(Parameter<?> parameter) {
        this.allParameters.enter(parameter);
    }

    private boolean inCurrentCondition(Property property) {
        Condition currentCondition = this.currentConditions.peek();
        if (currentCondition == null) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean();
        currentCondition.accept(segment -> {
            if (segment == property) {
                result.compareAndSet(false, true);
            }
        });
        return result.get();
    }

    private StatementCatalog.PropertyFilter extractPropertyCondition(StatementCatalog.Property property, Condition condition) {
        final AtomicReference left = new AtomicReference();
        final AtomicReference op = new AtomicReference();
        final AtomicReference right = new AtomicReference();
        condition.accept(new Visitor(){
            int cnt;

            @Override
            public void enter(Visitable segment) {
                Expression expression;
                if (++this.cnt != 2) {
                    return;
                }
                if (segment instanceof Operator) {
                    Operator operator = (Operator)segment;
                    op.compareAndSet(null, operator);
                } else if (segment instanceof Expression && !left.compareAndSet(null, expression = (Expression)segment)) {
                    right.compareAndSet(null, expression);
                }
            }

            @Override
            public void leave(Visitable segment) {
                --this.cnt;
            }
        });
        ParameterCollectingVisitor.ParameterInformation parameterInformation = this.extractParameters((Expression)left.get(), (Expression)right.get());
        return new StatementCatalog.PropertyFilter(this.currentClause.get(), (Expression)left.get(), (Operator)op.get(), (Expression)right.get(), parameterInformation.names, parameterInformation.values);
    }

    void enter(NodeLabel label) {
        this.tokens.add(new StatementCatalog.Token(StatementCatalog.Token.Type.NODE_LABEL, label.getValue()));
        Condition currentCondition = this.currentConditions.peek();
        if (currentCondition instanceof HasLabelCondition) {
            HasLabelCondition hasLabelCondition = (HasLabelCondition)currentCondition;
            this.currentHasLabelCondition.get().add(StatementCatalog.Token.label(label));
        }
    }

    void enter(LabelExpression labelExpression) {
        StatementCatalogBuildingVisitor.collectLabels(labelExpression, null, this.tokens);
    }

    PatternElement lookup(SymbolicName s) {
        if (this.patternLookup.isEmpty()) {
            throw new IllegalStateException("Invalid scope");
        }
        return this.patternLookup.peek().get(s);
    }

    void enter(Condition condition) {
        if (TYPE_OF_COMPOUND_CONDITION.equals(condition.getClass().getName())) {
            return;
        }
        this.currentConditions.push(condition);
        if (condition instanceof HasLabelCondition) {
            this.currentHasLabelCondition.compareAndSet(null, new TreeSet());
        }
    }

    void enter(Literal<?> literal) {
        if (literal instanceof Asterisk || literal instanceof PeriodLiteral || literal instanceof RawLiteral.RawElement || literal == LiteralBase.BLANK || literal == ListOperator.DOTS || literal instanceof Namespace) {
            return;
        }
        this.literals.add(literal);
    }

    void leave(Condition condition) {
        if (TYPE_OF_COMPOUND_CONDITION.equals(condition.getClass().getName())) {
            return;
        }
        this.currentConditions.pop();
        Set setOfRequiredTokens = this.currentHasLabelCondition.getAndSet(null);
        if (condition instanceof HasLabelCondition) {
            HasLabelCondition hasLabelCondition = (HasLabelCondition)condition;
            if (setOfRequiredTokens != null) {
                AtomicReference symbolicName = new AtomicReference();
                hasLabelCondition.accept(segment -> {
                    if (segment instanceof SymbolicName) {
                        SymbolicName s = (SymbolicName)segment;
                        symbolicName.compareAndSet(null, s.getValue());
                    }
                });
                this.labelFilters.add(new StatementCatalog.LabelFilter((String)symbolicName.get(), setOfRequiredTokens));
            }
        }
    }

    void store(SymbolicName s, PatternElement patternElement) {
        if (this.patternLookup.isEmpty()) {
            throw new IllegalStateException("Invalid scope");
        }
        Map<SymbolicName, PatternElement> currentScope = this.patternLookup.peek();
        if (currentScope.containsKey(s) && (this.scopingStrategy.getCurrentImports().contains(s) || this.patternLookup.size() == 1)) {
            return;
        }
        currentScope.put(s, patternElement);
    }

    private ParameterCollectingVisitor.ParameterInformation extractParameters(Expression ... expressions) {
        ParameterCollectingVisitor parameterCollectingVisitor = new ParameterCollectingVisitor(this.statementContext, this.renderConstantsAsParameters);
        for (Expression expression : expressions) {
            if (expression == null) continue;
            expression.accept(parameterCollectingVisitor);
        }
        return parameterCollectingVisitor.getResult();
    }

    static final class DefaultStatementCatalog
    implements StatementCatalog {
        private final Set<StatementCatalog.Token> tokens;
        private final Set<StatementCatalog.Property> properties;
        private final Collection<StatementCatalog.LabelFilter> labelFilters;
        private final Map<StatementCatalog.Property, Collection<StatementCatalog.PropertyFilter>> propertyFilters;
        private final Set<Expression> identifiableExpressions;
        private final ParameterCollectingVisitor.ParameterInformation parameterInformation;
        private final Map<StatementCatalog.Token, Relationships> relationships;
        private final Set<Literal<?>> literals;

        DefaultStatementCatalog(Set<StatementCatalog.Token> tokens, Set<StatementCatalog.LabelFilter> labelFilters, Set<StatementCatalog.Property> properties, Map<StatementCatalog.Property, Set<StatementCatalog.PropertyFilter>> propertyFilters, Collection<Expression> identifiableExpressions, ParameterCollectingVisitor.ParameterInformation parameterInformation, Map<StatementCatalog.Token, Relationships> relationships, Set<Literal<?>> literals) {
            Set<Expression> set;
            this.tokens = Collections.unmodifiableSet(tokens);
            this.labelFilters = Collections.unmodifiableSet(labelFilters);
            this.properties = Collections.unmodifiableSet(properties);
            this.propertyFilters = propertyFilters.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Collections.unmodifiableSet((Set)e.getValue())));
            if (identifiableExpressions instanceof Set) {
                Set s = (Set)identifiableExpressions;
                set = Collections.unmodifiableSet(s);
            } else {
                set = Set.copyOf(identifiableExpressions);
            }
            this.identifiableExpressions = set;
            this.parameterInformation = parameterInformation;
            this.relationships = relationships.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((Relationships)e.getValue()).copy()));
            this.literals = Collections.unmodifiableSet(literals);
        }

        public Set<StatementCatalog.Token> getAllTokens() {
            return this.tokens;
        }

        public Set<StatementCatalog.Property> getProperties() {
            return this.properties;
        }

        @Override
        public Collection<StatementCatalog.LabelFilter> getAllLabelFilters() {
            return this.labelFilters;
        }

        @Override
        public Map<StatementCatalog.Property, Collection<StatementCatalog.PropertyFilter>> getAllPropertyFilters() {
            return this.propertyFilters;
        }

        public Set<Expression> getIdentifiableExpressions() {
            return this.identifiableExpressions;
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.parameterInformation.values;
        }

        @Override
        public Collection<String> getParameterNames() {
            return this.parameterInformation.names;
        }

        @Override
        public Map<String, String> getRenamedParameters() {
            return this.parameterInformation.renames;
        }

        @Override
        public Collection<StatementCatalog.Token> getOutgoingRelations(StatementCatalog.Token label) {
            return this.extractRelations(label, Relationships::outgoing);
        }

        private Collection<StatementCatalog.Token> extractRelations(StatementCatalog.Token label, Function<Relationships, Set<StatementCatalog.Token>> tokenProvider) {
            if (label.type() != StatementCatalog.Token.Type.NODE_LABEL) {
                throw new IllegalArgumentException(String.valueOf(label) + " must be a node label, not a relationship type");
            }
            return tokenProvider.apply(this.relationships.getOrDefault(label, Relationships.empty()));
        }

        @Override
        public Collection<StatementCatalog.Token> getTargetNodes(StatementCatalog.Token type) {
            if (type.type() != StatementCatalog.Token.Type.RELATIONSHIP_TYPE) {
                throw new IllegalArgumentException(String.valueOf(type) + " must be a relationship type, not a node label");
            }
            return this.relationships.entrySet().stream().filter(e -> ((Relationships)e.getValue()).incoming().contains(type)).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        @Override
        public Collection<StatementCatalog.Token> getIncomingRelations(StatementCatalog.Token label) {
            return this.extractRelations(label, Relationships::incoming);
        }

        @Override
        public Collection<StatementCatalog.Token> getSourceNodes(StatementCatalog.Token type) {
            if (type.type() != StatementCatalog.Token.Type.RELATIONSHIP_TYPE) {
                throw new IllegalArgumentException(String.valueOf(type) + " must be a relationship type, not a node label");
            }
            return this.relationships.entrySet().stream().filter(e -> ((Relationships)e.getValue()).outgoing().contains(type)).map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        @Override
        public Collection<StatementCatalog.Token> getUndirectedRelations(StatementCatalog.Token label) {
            return this.extractRelations(label, Relationships::undirected);
        }

        public Set<Literal<?>> getLiterals() {
            return this.literals;
        }
    }

    record Relationships(Set<StatementCatalog.Token> outgoing, Set<StatementCatalog.Token> incoming, Set<StatementCatalog.Token> undirected) {
        Relationships() {
            this(new HashSet<StatementCatalog.Token>(), new HashSet<StatementCatalog.Token>(), new HashSet<StatementCatalog.Token>());
        }

        static Relationships empty() {
            return new Relationships(Set.of(), Set.of(), Set.of());
        }

        Relationships copy() {
            return new Relationships(Set.copyOf(this.outgoing), Set.copyOf(this.incoming), Set.copyOf(this.undirected));
        }
    }
}

