/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapProjection;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.LRUCache;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class SymbolicName
implements Expression,
IdentifiableElement {
    private static final Map<String, SymbolicName> CACHE = Collections.synchronizedMap(new LRUCache(32));
    private final String value;

    private SymbolicName(String value) {
        this.value = value;
    }

    static SymbolicName of(String name) {
        Assertions.hasText(name, "Name must not be empty.");
        return CACHE.computeIfAbsent(name, SymbolicName::new);
    }

    static SymbolicName unsafe(String name) {
        Assertions.hasText(name, "Name must not be empty.");
        return new SymbolicName(name);
    }

    static SymbolicName unresolved() {
        return new SymbolicName(null);
    }

    @API(status=API.Status.INTERNAL)
    public String getValue() {
        return this.value;
    }

    public SymbolicName concat(String otherValue) {
        Assertions.notNull(otherValue, "Value to concat must not be null.");
        if (otherValue.isEmpty()) {
            return this;
        }
        return SymbolicName.of(this.value + otherValue);
    }

    public MapProjection project(List<Object> entries) {
        return this.project(entries.toArray());
    }

    public MapProjection project(Object ... entries) {
        return MapProjection.create(this, entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.value == null) {
            return false;
        }
        SymbolicName that = (SymbolicName)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value != null ? Objects.hash(this.value) : super.hashCode();
    }

    @Override
    public String toString() {
        return this.value != null ? RendererBridge.render(this) : "Unresolved SymbolicName";
    }

    @Override
    public Expression asExpression() {
        return this;
    }
}

