/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AbstractStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.UnionPart;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.INTERNAL, since="1.0")
final class UnionQueryImpl
extends AbstractStatement
implements Statement.UnionQuery {
    private final boolean all;
    private final Statement firstQuery;
    private final List<UnionPart> additionalQueries;

    private UnionQueryImpl(boolean all, Statement firstQuery, List<UnionPart> additionalQueries) {
        this.all = all;
        this.firstQuery = firstQuery;
        this.additionalQueries = additionalQueries;
    }

    static UnionQueryImpl create(boolean unionAll, List<Statement> queries) {
        Assertions.isTrue(queries != null && queries.size() >= 2, "At least two queries are needed.");
        List<UnionPart> unionParts = queries.stream().skip(1L).map(q -> new UnionPart(unionAll, (Statement)q)).toList();
        return new UnionQueryImpl(unionAll, queries.get(0), unionParts);
    }

    UnionQueryImpl addAdditionalQueries(List<Statement> newAdditionalQueries) {
        ArrayList<Statement> queries = new ArrayList<Statement>();
        queries.add(this.firstQuery);
        queries.addAll(this.additionalQueries.stream().map(UnionPart::getQuery).toList());
        queries.addAll(newAdditionalQueries);
        return UnionQueryImpl.create(this.isAll(), queries);
    }

    boolean isAll() {
        return this.all;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.firstQuery.accept(visitor);
        this.additionalQueries.forEach(q -> q.accept(visitor));
        visitor.leave(this);
    }
}

