/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl.internal;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AliasedExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Parameter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementContext;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.FixedNamesStrategy;
import org.neo4j.jdbc.internal.shaded.cypherdsl.internal.GeneratedNamesStrategy;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Configuration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@API(status=API.Status.INTERNAL, since="2023.2.0")
public interface NameResolvingStrategy {
    public static NameResolvingStrategy useGeneratedNames(StatementContext context, Set<Configuration.GeneratedNames> config) {
        return new GeneratedNamesStrategy(context, config);
    }

    public static NameResolvingStrategy useGeneratedParameterNames(StatementContext context) {
        return new GeneratedNamesStrategy(context, EnumSet.of(Configuration.GeneratedNames.PARAMETER_NAMES));
    }

    public static NameResolvingStrategy useGivenNames(StatementContext context) {
        return new FixedNamesStrategy(context);
    }

    public String resolve(SymbolicName var1, boolean var2, boolean var3);

    public String resolve(AliasedExpression var1, boolean var2, boolean var3);

    public boolean isResolved(SymbolicName var1);

    public String resolve(Parameter<?> var1);

    default public void enterScope(Visitable cause, Collection<IdentifiableElement> imports) {
    }

    default public void leaveScope(Visitable cause, Collection<IdentifiableElement> exports) {
    }
}

