/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.dotenv.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.jdbc.internal.shaded.dotenv.DotenvEntry;
import org.neo4j.jdbc.internal.shaded.dotenv.DotenvException;
import org.neo4j.jdbc.internal.shaded.dotenv.internal.DotenvReader;

public class DotenvParser {
    private static final Pattern WHITE_SPACE_REGEX = Pattern.compile("^\\s*$");
    private static final Pattern DOTENV_ENTRY_REGEX = Pattern.compile("^\\s*([\\w.\\-]+)\\s*(=)\\s*(['][^']*[']|[\"][^\"]*[\"]|[^#]*)?\\s*(#.*)?$");
    private final DotenvReader reader;
    private final boolean throwIfMissing;
    private final boolean throwIfMalformed;
    private static final Predicate<String> isWhiteSpace = s -> DotenvParser.matches(WHITE_SPACE_REGEX, s);
    private static final Predicate<String> isComment = s -> s.startsWith("#") || s.startsWith("////");
    private static final Predicate<String> isQuoted = s -> s.length() > 1 && s.startsWith("\"") && s.endsWith("\"");
    private final Function<String, DotenvEntry> parseLine = s -> DotenvParser.matchEntry(DOTENV_ENTRY_REGEX, s);

    public DotenvParser(DotenvReader reader, boolean throwIfMissing, boolean throwIfMalformed) {
        this.reader = reader;
        this.throwIfMissing = throwIfMissing;
        this.throwIfMalformed = throwIfMalformed;
    }

    public List<DotenvEntry> parse() throws DotenvException {
        List<String> lines = this.lines();
        ArrayList<DotenvEntry> entries = new ArrayList<DotenvEntry>();
        Object currentEntry = "";
        for (String line : lines) {
            if (((String)currentEntry).equals("") && (isWhiteSpace.test(line) || isComment.test(line) || DotenvParser.isBlank(line))) continue;
            DotenvEntry entry = this.parseLine.apply((String)(currentEntry = (String)currentEntry + line));
            if (entry == null) {
                if (this.throwIfMalformed) {
                    throw new DotenvException("Malformed entry " + (String)currentEntry);
                }
                currentEntry = "";
                continue;
            }
            String value = entry.getValue();
            if (QuotedStringValidator.startsWithQuote(value) && !QuotedStringValidator.endsWithQuote(value)) {
                currentEntry = (String)currentEntry + "\n";
                continue;
            }
            if (!QuotedStringValidator.isValid(entry.getValue())) {
                if (this.throwIfMalformed) {
                    throw new DotenvException("Malformed entry, unmatched quotes " + line);
                }
                currentEntry = "";
                continue;
            }
            String key = entry.getKey();
            value = QuotedStringValidator.stripQuotes(entry.getValue());
            entries.add(new DotenvEntry(key, value));
            currentEntry = "";
        }
        return entries;
    }

    private List<String> lines() throws DotenvException {
        try {
            return this.reader.read();
        }
        catch (DotenvException e) {
            if (this.throwIfMissing) {
                throw e;
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new DotenvException(e);
        }
    }

    private static boolean matches(Pattern regex, String text) {
        return regex.matcher(text).matches();
    }

    private static DotenvEntry matchEntry(Pattern regex, String text) {
        Matcher matcher = regex.matcher(text);
        if (!matcher.matches() || matcher.groupCount() < 3) {
            return null;
        }
        return new DotenvEntry(matcher.group(1), matcher.group(3));
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static class QuotedStringValidator {
        private QuotedStringValidator() {
        }

        private static boolean isValid(String input) {
            String s = input.trim();
            if (QuotedStringValidator.isNotQuoted(s)) {
                return true;
            }
            if (QuotedStringValidator.doesNotStartAndEndWithQuote(s)) {
                return false;
            }
            return !QuotedStringValidator.hasUnescapedQuote(s);
        }

        private static boolean hasUnescapedQuote(String s) {
            boolean hasUnescapedQuote = false;
            String content = s.substring(1, s.length() - 1);
            Pattern quotePattern = Pattern.compile("\"");
            Matcher matcher = quotePattern.matcher(content);
            while (matcher.find()) {
                int quoteIndex = matcher.start();
                if (quoteIndex != 0 && content.charAt(quoteIndex - 1) == '\\') continue;
                hasUnescapedQuote = true;
            }
            return hasUnescapedQuote;
        }

        private static boolean doesNotStartAndEndWithQuote(String s) {
            return s.length() == 1 || !QuotedStringValidator.startsWithQuote(s) || !QuotedStringValidator.endsWithQuote(s);
        }

        private static boolean endsWithQuote(String s) {
            return s.endsWith("\"");
        }

        private static boolean startsWithQuote(String s) {
            return s.startsWith("\"");
        }

        private static boolean isNotQuoted(String s) {
            return !QuotedStringValidator.startsWithQuote(s) && !QuotedStringValidator.endsWithQuote(s);
        }

        private static String stripQuotes(String input) {
            String tr = input.trim();
            return isQuoted.test(tr) ? tr.substring(1, input.length() - 1) : tr;
        }
    }
}

