/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.neo4j.jdbc.internal.shaded.jooq.Binding;
import org.neo4j.jdbc.internal.shaded.jooq.BindingGetSQLInputContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingGetStatementContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingRegisterContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingSQLContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingSetSQLOutputContext;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;

public abstract class AbstractBinding<T, U>
implements Binding<T, U> {
    @Override
    public void sql(BindingSQLContext<U> ctx) throws SQLException {
        if (ctx.render().paramType() == ParamType.INLINED) {
            if (ctx.value() == null) {
                ctx.render().visit(Keywords.K_NULL);
            } else {
                this.sqlInline(ctx);
            }
        } else {
            this.sqlBind(ctx);
        }
    }

    protected void sqlInline(BindingSQLContext<U> ctx) throws SQLException {
        ctx.render().visit(DSL.inline(String.valueOf(ctx.value())));
    }

    protected void sqlBind(BindingSQLContext<U> ctx) throws SQLException {
        ctx.render().sql(ctx.variable());
    }

    @Override
    public void register(BindingRegisterContext<U> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException("AbstractBinding::register");
    }

    @Override
    public void get(BindingGetStatementContext<U> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException("AbstractBinding::get");
    }

    @Override
    public void set(BindingSetSQLOutputContext<U> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException("AbstractBinding::set");
    }

    @Override
    public void get(BindingGetSQLInputContext<U> ctx) throws SQLException {
        throw new SQLFeatureNotSupportedException("AbstractBinding::get");
    }
}

