/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.time.Instant;
import java.util.Map;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.DSLContext;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.Scope;
import org.neo4j.jdbc.internal.shaded.jooq.conf.Settings;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DataMap;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultConfiguration;

abstract class AbstractLazyScope
implements Scope {
    private final Configuration configuration;
    private Map<Object, Object> data;
    private final Instant creationTime;

    AbstractLazyScope(Configuration configuration) {
        this(configuration, null);
    }

    AbstractLazyScope(Configuration configuration, Map<Object, Object> data) {
        if (configuration == null) {
            configuration = new DefaultConfiguration();
        }
        this.configuration = configuration;
        this.data = data;
        this.creationTime = configuration.clock().instant();
    }

    @Override
    public final Instant creationTime() {
        return this.creationTime;
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final DSLContext dsl() {
        return this.configuration.dsl();
    }

    @Override
    public final Settings settings() {
        return this.configuration.settings();
    }

    @Override
    public final SQLDialect dialect() {
        return this.configuration.dialect();
    }

    @Override
    public final SQLDialect family() {
        return this.configuration.family();
    }

    @Override
    public final Map<Object, Object> data() {
        if (this.data == null) {
            this.data = new DataMap();
        }
        return this.data;
    }

    @Override
    public final Object data(Object key) {
        return this.data().get(key);
    }

    @Override
    public final Object data(Object key, Object value) {
        return this.data().put(key, value);
    }
}

