/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import org.neo4j.jdbc.internal.shaded.jooq.Block;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Keyword;
import org.neo4j.jdbc.internal.shaded.jooq.LanguageContext;
import org.neo4j.jdbc.internal.shaded.jooq.Query;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.Statement;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRowCountQuery;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultRenderContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.NullStatement;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class BlockImpl
extends AbstractRowCountQuery
implements Block {
    private static final Set<SQLDialect> SUPPORTS_NULL_STATEMENT = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    final Collection<? extends Statement> statements;
    final boolean alwaysWrapInBeginEnd;
    static final String STATEMENT_VARIABLES = "org.neo4j.jdbc.internal.shaded.jooq.impl.BlockImpl.statement-variables";

    BlockImpl(Configuration configuration, Collection<? extends Statement> statements, boolean alwaysWrapInBeginEnd) {
        super(configuration);
        this.statements = Tools.collect(Tools.filter(statements, s -> !(s instanceof NullStatement)));
        this.alwaysWrapInBeginEnd = alwaysWrapInBeginEnd;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                if (Tools.increment(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING)) {
                    ctx.paramType(ParamType.INLINED).visit(Keywords.K_EXECUTE_BLOCK).sql(' ').visit(Keywords.K_AS);
                    ctx.data(Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                    BlockImpl.scopeDeclarations(ctx.formatIndentStart(), c -> this.accept0((Context<?>)c.formatIndentEnd().formatSeparator()));
                } else {
                    this.accept0(ctx);
                }
                Tools.decrement(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING);
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                BlockImpl.bodyAsString(ctx, Keywords.K_DO, c -> this.accept0((Context<?>)c));
                break;
            }
            case H2: {
                String name = BlockImpl.randomName();
                if (Tools.increment(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING)) {
                    ctx.paramType(ParamType.INLINED).visit(Keywords.K_CREATE).sql(' ').visit(Keywords.K_ALIAS).sql(' ').sql(name).sql(' ').visit(Keywords.K_AS).sql(" $$").formatIndentStart().formatSeparator().sql("void x(Connection c) throws SQLException ");
                    ctx.data(Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
                }
                this.accept0(ctx);
                if (!Tools.decrement(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING)) break;
                ctx.formatIndentEnd().formatSeparator().sql("$$;").formatSeparator().visit(Keywords.K_CALL).sql(' ').sql(name).sql("();").formatSeparator().visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_ALIAS).sql(' ').sql(name).sql(';');
                break;
            }
            case MYSQL: {
                this.accept0(ctx);
                break;
            }
            default: {
                Tools.increment(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING);
                this.accept0(ctx);
                Tools.decrement(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING);
            }
        }
    }

    static final void scopeDeclarations(Context<?> ctx, Consumer<? super Context<?>> runnable) {
        if (!ctx.configuration().commercial()) {
            runnable.accept(ctx);
            return;
        }
    }

    static final void bodyAsString(Context<?> ctx, Keyword keyword, Consumer<? super Context<?>> runnable) {
        ParamType previous = ctx.paramType();
        if (Tools.increment(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING)) {
            ctx.paramType(ParamType.INLINED);
            if (keyword != null) {
                ctx.visit(keyword).sql(' ');
            }
            ctx.sql('$').sql(ctx.settings().getRenderDollarQuotedStringToken()).sql('$').formatSeparator().data(Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT, true);
        }
        runnable.accept(ctx);
        if (Tools.decrement(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING)) {
            ctx.formatSeparator().sql('$').sql(ctx.settings().getRenderDollarQuotedStringToken()).sql('$').paramType(previous);
        }
    }

    private static final String randomName() {
        return "block_" + System.currentTimeMillis() + "_" + (long)(1.0E7 * Math.random());
    }

    private final void accept0(Context<?> ctx) {
        boolean wrapInBeginEnd = this.alwaysWrapInBeginEnd;
        if (wrapInBeginEnd) {
            boolean topLevel = ctx.scopeLevel() == -1;
            LanguageContext language = ctx.languageContext();
            if (topLevel && language == LanguageContext.QUERY) {
                ctx.languageContext(LanguageContext.BLOCK);
            }
            BlockImpl.begin(ctx, topLevel);
            BlockImpl.scopeDeclarations(ctx, c -> this.accept1((Context<?>)c));
            BlockImpl.end(ctx, topLevel);
            if (topLevel && language == LanguageContext.QUERY) {
                ctx.languageContext(language);
            }
        } else {
            this.accept1(ctx);
        }
    }

    private final void accept1(Context<?> ctx) {
        if (this.statements.isEmpty()) {
            switch (ctx.family()) {
                default: 
            }
        } else {
            for (Statement statement : this.statements) {
                if (statement instanceof NullStatement && !SUPPORTS_NULL_STATEMENT.contains((Object)ctx.dialect())) continue;
                if (statement instanceof Query && !(statement instanceof Block)) {
                    ctx.languageContext(LanguageContext.QUERY, statement, c -> BlockImpl.accept2(c, s));
                    continue;
                }
                BlockImpl.accept2(ctx, statement);
            }
        }
    }

    private static final void accept2(Context<?> ctx, Statement s) {
        int n;
        int n2;
        DefaultRenderContext d;
        ctx.formatSeparator();
        if (ctx instanceof DefaultRenderContext) {
            d = (DefaultRenderContext)ctx;
            n2 = d.sql.length();
        } else {
            n2 = 0;
        }
        int position = n2;
        ctx.visit(s);
        if (ctx instanceof DefaultRenderContext) {
            d = (DefaultRenderContext)ctx;
            n = d.sql.length();
        } else {
            n = 0;
        }
        if (position < n) {
            BlockImpl.semicolonAfterStatement(ctx, s);
        }
    }

    static final void semicolonAfterStatement(Context<?> ctx, Statement s) {
        if (s instanceof Block) {
            return;
        }
        ctx.sql(';');
    }

    private static final void begin(Context<?> ctx, boolean topLevel) {
        if (ctx.family() == SQLDialect.H2) {
            ctx.sql('{');
        } else {
            ctx.visit(Keywords.K_BEGIN);
        }
        if (ctx.family() == SQLDialect.MARIADB && Tools.toplevel(ctx.data(), Tools.SimpleDataKey.DATA_BLOCK_NESTING)) {
            ctx.sql(' ').visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_ATOMIC);
        } else if (ctx.family() == SQLDialect.HSQLDB) {
            ctx.sql(' ').visit(Keywords.K_ATOMIC);
        }
        ctx.formatIndentStart();
    }

    private static final void end(Context<?> ctx, boolean topLevel) {
        ctx.formatIndentEnd().formatSeparator();
        if (ctx.family() == SQLDialect.H2) {
            ctx.sql('}');
        } else {
            ctx.visit(Keywords.K_END);
        }
        switch (ctx.family()) {
            case FIREBIRD: 
            case H2: {
                break;
            }
            default: {
                ctx.sql(';');
            }
        }
    }

    @Override
    public final QOM.UnmodifiableList<? extends Statement> $statements() {
        return QOM.unmodifiable(this.statements);
    }
}

