/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.jdbc.internal.shaded.jooq.impl.JSONContentHandler;

final class DefaultJSONContentHandler
implements JSONContentHandler {
    private final List<Object> result = new ArrayList<Object>();

    DefaultJSONContentHandler() {
    }

    @Override
    public final void startObject() {
        this.result.add(new LinkedHashMap());
    }

    @Override
    public final void endObject() {
        this.add(this.remove());
    }

    @Override
    public final void property(String key) {
        this.result.add(key);
    }

    @Override
    public final void startArray() {
        this.result.add(new ArrayList());
    }

    @Override
    public final void endArray() {
        this.add(this.remove());
    }

    @Override
    public final void valueNull() {
        this.add(null);
    }

    @Override
    public final void valueFalse() {
        this.add(false);
    }

    @Override
    public final void valueTrue() {
        this.add(true);
    }

    @Override
    public final void valueNumber(String string) {
        this.add(new BigDecimal(string));
    }

    @Override
    public final void valueString(String string) {
        this.add(string);
    }

    private final void add(Object object) {
        Object last;
        Object object2 = last = this.result.isEmpty() ? null : this.result();
        if (last instanceof List) {
            ((List)last).add(object);
        } else if (last instanceof String) {
            String property = (String)last;
            this.remove();
            ((Map)this.result()).put(property, object);
        } else {
            this.result.add(object);
        }
    }

    final Object remove() {
        return this.result.remove(this.result.size() - 1);
    }

    final Object result() {
        return this.result.get(this.result.size() - 1);
    }
}

