/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Meta;
import org.neo4j.jdbc.internal.shaded.jooq.MetaProvider;
import org.neo4j.jdbc.internal.shaded.jooq.impl.MetaImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.NoConnectionProvider;
import org.neo4j.jdbc.internal.shaded.jooq.tools.JooqLogger;

public class DefaultMetaProvider
implements MetaProvider {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultMetaProvider.class);
    private final Configuration configuration;

    public DefaultMetaProvider(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Meta provide() {
        return new MetaImpl(this.configuration, null);
    }

    static Meta meta(Configuration configuration) {
        Meta meta = configuration.metaProvider().provide();
        if (meta instanceof MetaImpl && configuration.connectionProvider() instanceof NoConnectionProvider) {
            log.debug("No MetaProvider configured. For best results when looking up meta data, configure a MetaProvider, or connect to a database");
            return configuration.dsl().meta("");
        }
        return meta;
    }
}

