/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.tools.r2dbc;

import org.neo4j.jdbc.internal.shaded.jooq.tools.JooqLogger;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.Batch;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.Result;
import org.neo4j.jdbc.internal.shaded.reactivestreams.Publisher;

public class LoggingBatch
implements Batch {
    private static final JooqLogger log = JooqLogger.getLogger(LoggingBatch.class);
    private final Batch delegate;

    public LoggingBatch(Batch delegate) {
        this.delegate = delegate;
    }

    public Batch getDelegate() {
        return this.delegate;
    }

    @Override
    public Batch add(String sql) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Batch::add", sql);
        }
        this.getDelegate().add(sql);
        return this;
    }

    @Override
    public Publisher<? extends Result> execute() {
        return s -> {
            if (log.isDebugEnabled()) {
                log.debug("Batch::execute");
            }
            this.getDelegate().execute().subscribe(s);
        };
    }
}

