/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.r2dbc.spi;

import java.util.ServiceLoader;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.Assert;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.ConnectionFactory;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.ConnectionFactoryOptions;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.ConnectionFactoryProvider;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.Nullable;

public final class ConnectionFactories {
    private ConnectionFactories() {
    }

    @Nullable
    public static ConnectionFactory find(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        for (ConnectionFactoryProvider provider : ConnectionFactories.loadProviders()) {
            if (!provider.supports(connectionFactoryOptions)) continue;
            return provider.create(connectionFactoryOptions);
        }
        return null;
    }

    public static ConnectionFactory get(String url) {
        return ConnectionFactories.get(ConnectionFactoryOptions.parse(Assert.requireNonNull(url, "R2DBC Connection URL must not be null")));
    }

    public static ConnectionFactory get(ConnectionFactoryOptions connectionFactoryOptions) {
        ConnectionFactory connectionFactory = ConnectionFactories.find(connectionFactoryOptions);
        if (connectionFactory == null) {
            throw new IllegalStateException(String.format("Unable to create a ConnectionFactory for '%s'. Available drivers: [ %s ]", connectionFactoryOptions, ConnectionFactories.getAvailableDrivers()));
        }
        return connectionFactory;
    }

    public static boolean supports(ConnectionFactoryOptions connectionFactoryOptions) {
        Assert.requireNonNull(connectionFactoryOptions, "connectionFactoryOptions must not be null");
        for (ConnectionFactoryProvider provider : ConnectionFactories.loadProviders()) {
            if (!provider.supports(connectionFactoryOptions)) continue;
            return true;
        }
        return false;
    }

    private static String getAvailableDrivers() {
        StringBuilder availableDrivers = new StringBuilder();
        for (ConnectionFactoryProvider provider : ConnectionFactories.loadProviders()) {
            if (availableDrivers.length() != 0) {
                availableDrivers.append(", ");
            }
            availableDrivers.append(provider.getDriver());
        }
        if (availableDrivers.length() == 0) {
            availableDrivers.append("None");
        }
        return availableDrivers.toString();
    }

    private static ServiceLoader<ConnectionFactoryProvider> loadProviders() {
        return ServiceLoader.load(ConnectionFactoryProvider.class, ConnectionFactoryProvider.class.getClassLoader());
    }
}

