/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.spi;

import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.jdbc.translator.spi.Cache;

final class LRUCache<K, V>
extends LinkedHashMap<K, V>
implements Cache<K, V> {
    private static final long serialVersionUID = 1413351305126601678L;
    private final int cacheSize;

    LRUCache(int cacheSize) {
        super(cacheSize / 4, 0.75f, true);
        this.cacheSize = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.cacheSize;
    }

    @Override
    public void flush() {
        this.clear();
    }
}

