/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.spi;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public record View(String name, String query, List<Column> columns) {
    public View {
        columns = List.copyOf(columns);
    }

    public static Column column(String name, String propertyName, String type) {
        return new Column(name, propertyName, type);
    }

    public record Column(String name, String propertyName, String type) {
        public Column {
            String msg = "Column name is required";
            if (Objects.requireNonNull(name, msg).isBlank()) {
                throw new IllegalArgumentException(msg);
            }
            propertyName = Optional.ofNullable(propertyName).filter(Predicate.not(String::isBlank)).orElse(name);
        }
    }
}

