/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Objects;
import org.neo4j.jdbc.values.AbstractValue;
import org.neo4j.jdbc.values.Type;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BooleanValue
extends AbstractValue {
    public static final BooleanValue TRUE = new TrueValue();
    public static final BooleanValue FALSE = new FalseValue();

    private BooleanValue() {
    }

    @Override
    public abstract Boolean asObject();

    @Override
    public Type type() {
        return Type.BOOLEAN;
    }

    private static final class TrueValue
    extends BooleanValue {
        private TrueValue() {
        }

        @Override
        public Boolean asObject() {
            return Boolean.TRUE;
        }

        @Override
        public boolean asBoolean() {
            return true;
        }

        @Override
        public boolean isTrue() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == TRUE;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(TRUE);
        }

        @Override
        public String toString() {
            return "TRUE";
        }
    }

    private static final class FalseValue
    extends BooleanValue {
        private FalseValue() {
        }

        @Override
        public Boolean asObject() {
            return Boolean.FALSE;
        }

        @Override
        public boolean asBoolean() {
            return false;
        }

        @Override
        public boolean isFalse() {
            return true;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == FALSE;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(FALSE);
        }

        @Override
        public String toString() {
            return "FALSE";
        }
    }
}

