/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import org.neo4j.jdbc.values.Value;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Type {
    ANY{

        @Override
        public boolean covers(Value value) {
            return !value.isNull();
        }
    }
    ,
    BOOLEAN,
    BYTES,
    STRING,
    NUMBER{

        @Override
        public boolean covers(Value value) {
            Type valueType = value.type();
            return valueType == this || valueType == INTEGER || valueType == FLOAT;
        }
    }
    ,
    INTEGER,
    FLOAT,
    LIST{

        public String toString() {
            return "LIST OF ANY?";
        }
    }
    ,
    MAP{

        @Override
        public boolean covers(Value value) {
            Type valueType = value.type();
            return valueType == MAP || valueType == NODE || valueType == RELATIONSHIP;
        }
    }
    ,
    NODE,
    RELATIONSHIP,
    PATH,
    POINT,
    DATE,
    TIME,
    LOCAL_TIME,
    LOCAL_DATE_TIME,
    DATE_TIME,
    DURATION,
    NULL,
    VECTOR;


    public final boolean isTypeOf(Value value) {
        return this.covers(value);
    }

    boolean covers(Value value) {
        return this == value.type();
    }
}

