/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.Neo4jTransaction;

final class ThrowingTransactionImpl
implements Neo4jTransaction {
    private Neo4jTransaction.State state = Neo4jTransaction.State.READY;

    ThrowingTransactionImpl() {
    }

    @Override
    public Neo4jTransaction.RunAndPullResponses runAndPull(String query, Map<String, Object> parameters, int fetchSize, int timeout) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Neo4jTransaction.DiscardResponse runAndDiscard(String query, Map<String, Object> parameters, int timeout, boolean commit) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Neo4jTransaction.PullResponse pull(Neo4jTransaction.RunResponse runResponse, long request) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void commit() throws SQLException {
        if (this.state != Neo4jTransaction.State.READY) {
            throw new Neo4jException(Neo4jException.GQLError.$2DN01.withTemplatedMessage("Cannot commit in %s state".formatted(new Object[]{this.state})));
        }
        this.state = Neo4jTransaction.State.COMMITTED;
    }

    @Override
    public void rollback() throws SQLException {
        if (this.state != Neo4jTransaction.State.READY) {
            throw new Neo4jException(Neo4jException.GQLError.$40N01.withTemplatedMessage("Cannot rollback in %s state".formatted(new Object[]{this.state})));
        }
        this.state = Neo4jTransaction.State.ROLLEDBACK;
    }

    @Override
    public void fail(SQLException exception) throws SQLException {
        if (this.state != Neo4jTransaction.State.READY) {
            throw new Neo4jException(Neo4jException.GQLError.$2DN03.withTemplatedMessage("Cannot fail in %s state".formatted(new Object[]{this.state})));
        }
        this.state = Neo4jTransaction.State.FAILED;
    }

    @Override
    public boolean isAutoCommit() {
        return false;
    }

    @Override
    public Neo4jTransaction.State getState() {
        return this.state;
    }
}

