/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.jdbc.values.Entity;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

abstract class AbstractEntity
implements Entity {
    private final long id;
    private final String elementId;
    private final Value properties;

    AbstractEntity(long id, String elementId, Map<String, Value> properties) {
        this.id = id;
        this.elementId = elementId;
        this.properties = Values.value(properties);
    }

    @Override
    @Deprecated
    public long id() {
        return this.id;
    }

    @Override
    public String elementId() {
        return this.elementId;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Map<String, Object> asMap() {
        return this.asMap(Values.ofObject());
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
        return this.properties.asMap(mapFunction);
    }

    @Override
    public Value asValue() {
        return Values.value(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractEntity that = (AbstractEntity)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "Entity{id=" + this.id + ", properties=" + String.valueOf(this.properties) + "}";
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public Iterable<String> keys() {
        return this.properties.keys();
    }

    @Override
    public Value get(String key) {
        Value value = this.properties.get(key);
        return value != null ? value : Values.NULL;
    }

    @Override
    public Iterable<Value> values() {
        return this.properties.values();
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        return AbstractEntity.map(this.properties.values(), mapFunction);
    }

    private static <A, B> Iterable<B> map(Iterable<A> it, final Function<A, B> f) {
        return () -> {
            final Iterator aIterator = it.iterator();
            return new Iterator<B>(){

                @Override
                public boolean hasNext() {
                    return aIterator.hasNext();
                }

                @Override
                public B next() {
                    return f.apply(aIterator.next());
                }

                @Override
                public void remove() {
                    aIterator.remove();
                }
            };
        };
    }
}

