/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlan;
import org.neo4j.jdbc.internal.shaded.bolt.SecurityPlanImpl;
import org.neo4j.jdbc.internal.shaded.bolt.ssl.RevocationCheckingStrategy;
import org.neo4j.jdbc.internal.shaded.bolt.ssl.SSLContexts;
import org.neo4j.jdbc.internal.shaded.bolt.ssl.TrustManagerFactories;

public final class SecurityPlans {
    public static SecurityPlan encrypted(SSLContext sslContext, boolean requiresHostnameVerification) {
        return SecurityPlans.encrypted(sslContext, requiresHostnameVerification, null);
    }

    public static SecurityPlan encrypted(SSLContext sslContext, boolean requiresHostnameVerification, String hostnameForVerification) {
        return new SecurityPlanImpl(sslContext, requiresHostnameVerification, hostnameForVerification);
    }

    public static SecurityPlan encryptedForAnyCertificate() throws GeneralSecurityException {
        SSLContext sslContext = SSLContexts.forAnyCertificate(new KeyManager[0]);
        return SecurityPlans.encrypted(sslContext, false);
    }

    public static SecurityPlan encryptedForSystemCASignedCertificates() throws GeneralSecurityException, IOException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactories.forSystemCertificates(RevocationCheckingStrategy.NO_CHECKS);
        SSLContext sslContext = SSLContexts.forTrustManagers(new KeyManager[0], trustManagerFactory.getTrustManagers());
        return SecurityPlans.encrypted(sslContext, true);
    }

    private SecurityPlans() {
    }
}

